/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.InvalidPathException;
import java.io.IOException;

public class AlluxioFS {
    public static void main(String[] args) throws FileAlreadyExistsException, InvalidPathException, AlluxioException, IOException {
        int bufSize = 4096;
        System.out.println("Start Alluxio Native FS write/read");
        FileSystem fs = FileSystem.Factory.get();
        AlluxioURI path = new AlluxioURI("/AlluxioFS.txt");
        FileOutStream out = fs.createFile(path);
        byte[] buffout = new byte[4096];
        for (int i = 0; i < 4096; ++i) {
            buffout[i] = (byte)(65 + i % 26);
        }
        out.write(buffout);
        out.close();
        System.out.println("End write");
        FileInStream in = fs.openFile(path);
        byte[] buffin = new byte[4096];
        in.read(buffin);
        in.close();
        System.out.println("End read:" + new String(buffin));
    }
}

