/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.client.job.JobMasterClient;
import alluxio.grpc.CancelPRequest;
import alluxio.grpc.GetJobStatusPRequest;
import alluxio.grpc.JobMasterClientServiceGrpc;
import alluxio.grpc.ListAllPRequest;
import alluxio.grpc.RunPRequest;
import alluxio.grpc.ServiceType;
import alluxio.job.JobConfig;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.JobInfo;
import alluxio.master.MasterClientContext;
import alluxio.worker.job.JobMasterClientContext;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RetryHandlingJobMasterClient
extends AbstractMasterClient
implements JobMasterClient {
    private JobMasterClientServiceGrpc.JobMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingJobMasterClient(JobMasterClientContext conf) {
        super((MasterClientContext)conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOB_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "JobMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void beforeConnect() throws IOException {
    }

    protected void afterConnect() throws IOException {
        this.mClient = JobMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public void cancel(final long jobId) throws IOException {
        this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Void>(){

            public Void call() {
                RetryHandlingJobMasterClient.this.mClient.cancel(CancelPRequest.newBuilder().setJobId(jobId).build());
                return null;
            }
        });
    }

    @Override
    public JobInfo getStatus(final long jobId) throws IOException {
        return new JobInfo((alluxio.grpc.JobInfo)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<alluxio.grpc.JobInfo>(){

            public alluxio.grpc.JobInfo call() throws StatusRuntimeException {
                return RetryHandlingJobMasterClient.this.mClient.getJobStatus(GetJobStatusPRequest.newBuilder().setJobId(jobId).build()).getJobInfo();
            }
        }));
    }

    @Override
    public List<Long> list() throws IOException {
        return (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<Long>>(){

            public List<Long> call() {
                return RetryHandlingJobMasterClient.this.mClient.listAll(ListAllPRequest.getDefaultInstance()).getJobIdsList();
            }
        });
    }

    @Override
    public long run(JobConfig jobConfig) throws IOException {
        final ByteString jobConfigStr = ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig));
        return (Long)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Long>(){

            public Long call() throws StatusRuntimeException {
                return RetryHandlingJobMasterClient.this.mClient.run(RunPRequest.newBuilder().setJobConfig(jobConfigStr).build()).getJobId();
            }
        });
    }
}

