/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.job.JobConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.retry.CountingRetry;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.worker.job.JobMasterClientContext;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JobGrpcClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JobGrpcClientUtils.class);

    public static void run(JobConfig config, int attempts, AlluxioConfiguration alluxioConf) throws InterruptedException {
        CountingRetry retryPolicy = new CountingRetry(attempts);
        while (retryPolicy.attempt()) {
            long jobId;
            try (JobMasterClient client = JobMasterClient.Factory.create(JobMasterClientContext.newBuilder(ClientContext.create((AlluxioConfiguration)alluxioConf)).build());){
                jobId = client.run(config);
            }
            catch (Exception e) {
                LOG.warn("Exception encountered when starting a job.", (Throwable)e);
                continue;
            }
            JobInfo jobInfo = JobGrpcClientUtils.waitFor(jobId, alluxioConf);
            if (jobInfo == null) break;
            if (jobInfo.getStatus() == Status.COMPLETED || jobInfo.getStatus() == Status.CANCELED) {
                return;
            }
            LOG.warn("Job {} failed to complete: {}", (Object)jobId, (Object)jobInfo.getErrorMessage());
        }
        throw new RuntimeException("Failed to successfully complete the job.");
    }

    private static JobInfo waitFor(long jobId, AlluxioConfiguration alluxioConf) throws InterruptedException {
        AtomicReference finishedJobInfo = new AtomicReference();
        try (JobMasterClient client = JobMasterClient.Factory.create(JobMasterClientContext.newBuilder(ClientContext.create((AlluxioConfiguration)alluxioConf)).build());){
            CommonUtils.waitFor((String)"Job to finish", () -> {
                JobInfo jobInfo;
                try {
                    jobInfo = client.getStatus(jobId);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get status for job (jobId={})", (Object)jobId, (Object)e);
                    return true;
                }
                switch (jobInfo.getStatus()) {
                    case FAILED: 
                    case CANCELED: 
                    case COMPLETED: {
                        finishedJobInfo.set(jobInfo);
                        return true;
                    }
                    case RUNNING: 
                    case CREATED: {
                        return false;
                    }
                }
                throw new IllegalStateException("Unrecognized job status: " + jobInfo.getStatus());
            }, (WaitForOptions)WaitForOptions.defaults().setInterval(1000));
        }
        catch (IOException e) {
            LOG.warn("Failed to close job master client: {}", (Object)e.toString());
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        return (JobInfo)finishedJobInfo.get();
    }

    private JobGrpcClientUtils() {
    }
}

