/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.JobCommand;
import alluxio.grpc.JobHeartbeatPRequest;
import alluxio.grpc.JobMasterWorkerServiceGrpc;
import alluxio.grpc.RegisterJobWorkerPRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.TaskInfo;
import alluxio.master.MasterClientContext;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.JobMasterClient;
import alluxio.worker.job.JobMasterClientContext;
import io.grpc.Channel;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RetryHandlingJobMasterClient
extends AbstractMasterClient
implements JobMasterClient {
    private JobMasterWorkerServiceGrpc.JobMasterWorkerServiceBlockingStub mClient = null;

    public RetryHandlingJobMasterClient(JobMasterClientContext conf) {
        super((MasterClientContext)conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOB_MASTER_WORKER_SERVICE;
    }

    protected String getServiceName() {
        return "JobMasterWorker";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void beforeConnect() throws IOException {
    }

    protected void afterConnect() {
        this.mClient = JobMasterWorkerServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public long registerWorker(final WorkerNetAddress address) throws IOException {
        return (Long)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Long>(){

            public Long call() {
                return RetryHandlingJobMasterClient.this.mClient.registerJobWorker(RegisterJobWorkerPRequest.newBuilder().setWorkerNetAddress(GrpcUtils.toProto((WorkerNetAddress)address)).build()).getId();
            }
        });
    }

    @Override
    public List<JobCommand> heartbeat(final long workerId, final List<TaskInfo> taskInfoList) throws IOException {
        return (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<JobCommand>>(){

            public List<JobCommand> call() {
                return RetryHandlingJobMasterClient.this.mClient.heartbeat(JobHeartbeatPRequest.newBuilder().setWorkerId(workerId).addAllTaskInfos((Iterable)taskInfoList).build()).getCommandsList();
            }
        });
    }
}

