/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.client.job.JobMasterClient;
import alluxio.grpc.CancelPRequest;
import alluxio.grpc.GetAllWorkerHealthPRequest;
import alluxio.grpc.GetJobServiceSummaryPRequest;
import alluxio.grpc.GetJobStatusPRequest;
import alluxio.grpc.JobMasterClientServiceGrpc;
import alluxio.grpc.ListAllPRequest;
import alluxio.grpc.RunPRequest;
import alluxio.grpc.ServiceType;
import alluxio.job.JobConfig;
import alluxio.job.ProtoUtils;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.JobServiceSummary;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.master.MasterClientContext;
import alluxio.worker.job.JobMasterClientContext;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RetryHandlingJobMasterClient
extends AbstractMasterClient
implements JobMasterClient {
    private JobMasterClientServiceGrpc.JobMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingJobMasterClient(JobMasterClientContext conf) {
        super((MasterClientContext)conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOB_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "JobMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = JobMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public void cancel(long jobId) throws IOException {
        this.retryRPC(() -> {
            this.mClient.cancel(CancelPRequest.newBuilder().setJobId(jobId).build());
            return null;
        });
    }

    @Override
    public JobInfo getJobStatus(final long id) throws IOException {
        return ProtoUtils.fromProto((alluxio.grpc.JobInfo)((alluxio.grpc.JobInfo)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<alluxio.grpc.JobInfo>(){

            public alluxio.grpc.JobInfo call() throws StatusRuntimeException {
                return RetryHandlingJobMasterClient.this.mClient.getJobStatus(GetJobStatusPRequest.newBuilder().setJobId(id).build()).getJobInfo();
            }
        })));
    }

    @Override
    public JobServiceSummary getJobServiceSummary() throws IOException {
        return new JobServiceSummary((alluxio.grpc.JobServiceSummary)this.retryRPC(() -> this.mClient.getJobServiceSummary(GetJobServiceSummaryPRequest.newBuilder().build()).getSummary()));
    }

    @Override
    public List<Long> list() throws IOException {
        return (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<Long>>(){

            public List<Long> call() {
                return RetryHandlingJobMasterClient.this.mClient.listAll(ListAllPRequest.getDefaultInstance()).getJobIdsList();
            }
        });
    }

    @Override
    public List<JobInfo> listDetailed() throws IOException {
        List jobProtoInfos = (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<alluxio.grpc.JobInfo>>(){

            public List<alluxio.grpc.JobInfo> call() {
                return RetryHandlingJobMasterClient.this.mClient.listAll(ListAllPRequest.getDefaultInstance()).getJobInfosList();
            }
        });
        ArrayList result = Lists.newArrayList();
        for (alluxio.grpc.JobInfo jobProtoInfo : jobProtoInfos) {
            result.add(ProtoUtils.fromProto((alluxio.grpc.JobInfo)jobProtoInfo));
        }
        return result;
    }

    @Override
    public long run(JobConfig jobConfig) throws IOException {
        final ByteString jobConfigStr = ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig));
        return (Long)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Long>(){

            public Long call() throws StatusRuntimeException {
                return RetryHandlingJobMasterClient.this.mClient.run(RunPRequest.newBuilder().setJobConfig(jobConfigStr).build()).getJobId();
            }
        });
    }

    @Override
    public List<JobWorkerHealth> getAllWorkerHealth() throws IOException {
        return (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<JobWorkerHealth>>(){

            public List<JobWorkerHealth> call() throws StatusRuntimeException {
                List workerHealthsList = RetryHandlingJobMasterClient.this.mClient.getAllWorkerHealth(GetAllWorkerHealthPRequest.newBuilder().build()).getWorkerHealthsList();
                return workerHealthsList.stream().map(JobWorkerHealth::new).collect(Collectors.toList());
            }
        });
    }
}

