/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.AlluxioURI;
import alluxio.client.job.JobMasterClient;
import alluxio.client.job.JobMasterClientPool;
import alluxio.exception.AlluxioException;
import alluxio.job.JobConfig;
import alluxio.job.plan.replicate.EvictConfig;
import alluxio.job.plan.replicate.MoveConfig;
import alluxio.job.plan.replicate.ReplicateConfig;
import alluxio.job.plan.replicate.ReplicationHandler;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultReplicationHandler
implements ReplicationHandler {
    private final JobMasterClientPool mJobMasterClientPool;

    public DefaultReplicationHandler(JobMasterClientPool jobMasterClientPool) {
        this.mJobMasterClientPool = jobMasterClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evict(AlluxioURI uri, long blockId, int numReplicas) throws AlluxioException, IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            long l = client.run((JobConfig)new EvictConfig(uri.getPath(), blockId, numReplicas));
            return l;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replicate(AlluxioURI uri, long blockId, int numReplicas) throws AlluxioException, IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            long l = client.run((JobConfig)new ReplicateConfig(uri.getPath(), blockId, numReplicas));
            return l;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long migrate(AlluxioURI uri, long blockId, String workerHost, String mediumType) throws AlluxioException, IOException {
        JobMasterClient client = (JobMasterClient)this.mJobMasterClientPool.acquire();
        try {
            long l = client.run((JobConfig)new MoveConfig(uri.getPath(), blockId, workerHost, mediumType));
            return l;
        }
        finally {
            this.mJobMasterClientPool.release(client);
        }
    }
}

