/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.client.job.JobMasterClient;
import alluxio.conf.PropertyKey;
import alluxio.resource.ResourcePool;
import alluxio.worker.job.JobMasterClientContext;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JobMasterClientPool
extends ResourcePool<JobMasterClient> {
    private final Queue<JobMasterClient> mClientList = new ConcurrentLinkedQueue<JobMasterClient>();
    private final JobMasterClientContext mMasterContext;

    public JobMasterClientPool(JobMasterClientContext context) {
        super(context.getClusterConf().getInt(PropertyKey.JOB_MASTER_CLIENT_THREADS));
        this.mMasterContext = context;
    }

    public void close() throws IOException {
        JobMasterClient client;
        while ((client = this.mClientList.poll()) != null) {
            client.close();
        }
    }

    protected JobMasterClient createNewResource() {
        JobMasterClient client = JobMasterClient.Factory.create(this.mMasterContext);
        this.mClientList.add(client);
        return client;
    }
}

