/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.client.job.JobMasterClientPool;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterInquireClient;
import alluxio.resource.CloseableResource;
import alluxio.security.user.UserState;
import alluxio.worker.job.JobMasterClientContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;

@ThreadSafe
public final class JobContext
implements Closeable {
    @GuardedBy(value="this")
    private MasterInquireClient mJobMasterInquireClient;
    private volatile JobMasterClientPool mJobMasterClientPool;

    public static JobContext create(AlluxioConfiguration alluxioConf, UserState userState) {
        JobContext context = new JobContext();
        context.init(alluxioConf, userState);
        return context;
    }

    private JobContext() {
    }

    private synchronized void init(AlluxioConfiguration alluxioConf, UserState userState) {
        this.mJobMasterInquireClient = MasterInquireClient.Factory.createForJobMaster((AlluxioConfiguration)alluxioConf, (UserState)userState);
        this.mJobMasterClientPool = new JobMasterClientPool(JobMasterClientContext.newBuilder(ClientContext.create((Subject)userState.getSubject(), (AlluxioConfiguration)alluxioConf)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.mJobMasterClientPool.close();
        this.mJobMasterClientPool = null;
        JobContext jobContext = this;
        synchronized (jobContext) {
            this.mJobMasterInquireClient = null;
        }
    }

    public synchronized InetSocketAddress getJobMasterAddress() throws UnavailableException {
        return this.mJobMasterInquireClient.getPrimaryRpcAddress();
    }

    public JobMasterClient acquireMasterClient() {
        return (JobMasterClient)this.mJobMasterClientPool.acquire();
    }

    public void releaseMasterClient(JobMasterClient masterClient) {
        this.mJobMasterClientPool.release(masterClient);
    }

    public CloseableResource<JobMasterClient> acquireMasterClientResource() {
        return new CloseableResource<JobMasterClient>((JobMasterClient)this.mJobMasterClientPool.acquire()){

            public void closeResource() {
                JobContext.this.mJobMasterClientPool.release((JobMasterClient)this.get());
            }
        };
    }
}

