/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.job;

import alluxio.AbstractJobMasterClient;
import alluxio.client.job.JobMasterClient;
import alluxio.grpc.CancelPRequest;
import alluxio.grpc.GetAllWorkerHealthPRequest;
import alluxio.grpc.GetCmdStatusDetailedRequest;
import alluxio.grpc.GetCmdStatusRequest;
import alluxio.grpc.GetJobServiceSummaryPRequest;
import alluxio.grpc.GetJobStatusDetailedPRequest;
import alluxio.grpc.GetJobStatusPRequest;
import alluxio.grpc.JobMasterClientServiceGrpc;
import alluxio.grpc.ListAllPOptions;
import alluxio.grpc.ListAllPRequest;
import alluxio.grpc.RunPRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.SubmitRequest;
import alluxio.job.CmdConfig;
import alluxio.job.JobConfig;
import alluxio.job.ProtoUtils;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.CmdStatusBlock;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.JobServiceSummary;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.job.wire.Status;
import alluxio.master.MasterClientContext;
import alluxio.worker.job.JobMasterClientContext;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RetryHandlingJobMasterClient
extends AbstractJobMasterClient
implements JobMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(JobMasterClient.class);
    private JobMasterClientServiceGrpc.JobMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingJobMasterClient(JobMasterClientContext conf) {
        super((MasterClientContext)conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOB_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "JobMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = JobMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public void cancel(long jobId) throws IOException {
        this.retryRPC(() -> {
            this.mClient.cancel(CancelPRequest.newBuilder().setJobId(jobId).build());
            return null;
        }, RPC_LOG, "Cancel", "jobId=%d", new Object[]{jobId});
    }

    @Override
    public JobInfo getJobStatus(long id) throws IOException {
        return ProtoUtils.fromProto((alluxio.grpc.JobInfo)((alluxio.grpc.JobInfo)this.retryRPC(() -> this.mClient.getJobStatus(GetJobStatusPRequest.newBuilder().setJobId(id).build()).getJobInfo(), RPC_LOG, "GetJobStatus", "id=%d", new Object[]{id})));
    }

    @Override
    public JobInfo getJobStatusDetailed(long id) throws IOException {
        return ProtoUtils.fromProto((alluxio.grpc.JobInfo)((alluxio.grpc.JobInfo)this.retryRPC(() -> this.mClient.getJobStatusDetailed(GetJobStatusDetailedPRequest.newBuilder().setJobId(id).build()).getJobInfo(), RPC_LOG, "GetJobStatusDetailed", "id=%d", new Object[]{id})));
    }

    @Override
    public JobServiceSummary getJobServiceSummary() throws IOException {
        return new JobServiceSummary((alluxio.grpc.JobServiceSummary)this.retryRPC(() -> this.mClient.getJobServiceSummary(GetJobServiceSummaryPRequest.newBuilder().build()).getSummary(), RPC_LOG, "GetJobServiceSummary", "", new Object[0]));
    }

    @Override
    public List<Long> list(ListAllPOptions option) throws IOException {
        return (List)this.retryRPC(() -> this.mClient.listAll(ListAllPRequest.newBuilder().setOptions(option.toBuilder().setJobIdOnly(true)).build()).getJobIdsList(), RPC_LOG, "List", "", new Object[0]);
    }

    @Override
    public List<JobInfo> listDetailed() throws IOException {
        List jobProtoInfos = (List)this.retryRPC(() -> this.mClient.listAll(ListAllPRequest.getDefaultInstance()).getJobInfosList(), RPC_LOG, "ListDetailed", "", new Object[0]);
        ArrayList result = Lists.newArrayList();
        for (alluxio.grpc.JobInfo jobProtoInfo : jobProtoInfos) {
            result.add(ProtoUtils.fromProto((alluxio.grpc.JobInfo)jobProtoInfo));
        }
        return result;
    }

    @Override
    public long run(JobConfig jobConfig) throws IOException {
        ByteString jobConfigStr = ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig));
        return (Long)this.retryRPC(() -> this.mClient.run(RunPRequest.newBuilder().setJobConfig(jobConfigStr).build()).getJobId(), RPC_LOG, "Run", "jobConfig=%s", new Object[]{jobConfig});
    }

    @Override
    public long submit(CmdConfig cmdConfig) throws IOException {
        ByteString cmdConfigStr = ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)cmdConfig));
        return (Long)this.retryRPC(() -> this.mClient.submit(SubmitRequest.newBuilder().setCmdConfig(cmdConfigStr).build()).getJobControlId(), RPC_LOG, "Submit", "cmdConfig=%s", new Object[]{cmdConfig});
    }

    @Override
    public List<JobWorkerHealth> getAllWorkerHealth() throws IOException {
        return (List)this.retryRPC(() -> {
            List workerHealthsList = this.mClient.getAllWorkerHealth(GetAllWorkerHealthPRequest.newBuilder().build()).getWorkerHealthsList();
            return workerHealthsList.stream().map(JobWorkerHealth::new).collect(Collectors.toList());
        }, RPC_LOG, "GetAllWorkerHealth", "", new Object[0]);
    }

    @Override
    public Status getCmdStatus(long id) throws IOException {
        return ProtoUtils.fromProto((alluxio.grpc.Status)((alluxio.grpc.Status)this.retryRPC(() -> this.mClient.getCmdStatus(GetCmdStatusRequest.newBuilder().setJobControlId(id).build()).getCmdStatus(), RPC_LOG, "GetCmdStatus", "jobControlId=%d", new Object[]{id})));
    }

    @Override
    public CmdStatusBlock getCmdStatusDetailed(long id) throws IOException {
        return ProtoUtils.convertToCmdStatusBlock((alluxio.grpc.CmdStatusBlock)((alluxio.grpc.CmdStatusBlock)this.retryRPC(() -> this.mClient.getCmdStatusDetailed(GetCmdStatusDetailedRequest.newBuilder().setJobControlId(id).build()).getCmdStatusBlock(), RPC_LOG, "getCmdStatusDetailed", "jobControlId=%d", new Object[]{id})));
    }
}

