/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.replicate;

import alluxio.job.replicate.EvictConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class EvictConfigTest {
    @Test
    public void json() throws Exception {
        EvictConfig config = EvictConfigTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        EvictConfig other = (EvictConfig)mapper.readValue(mapper.writeValueAsString((Object)config), EvictConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void negativeReplicas() {
        try {
            new EvictConfig(0L, -1);
            Assert.fail((String)"Cannot create EvictConfig with negative replicas");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void zeroReplicas() {
        try {
            new EvictConfig(0L, 0);
            Assert.fail((String)"Cannot create EvictConfig with zero replicas");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void checkEquality(EvictConfig a, EvictConfig b) {
        Assert.assertEquals((long)a.getBlockId(), (long)b.getBlockId());
        Assert.assertEquals((long)a.getReplicas(), (long)b.getReplicas());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static EvictConfig createRandom() {
        Random random = new Random();
        EvictConfig config = new EvictConfig(random.nextLong(), random.nextInt(Integer.MAX_VALUE) + 1);
        return config;
    }
}

