/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.replicate;

import alluxio.job.replicate.ReplicateConfig;
import alluxio.util.CommonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class ReplicateConfigTest {
    @Test
    public void json() throws Exception {
        ReplicateConfig config = ReplicateConfigTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        ReplicateConfig other = (ReplicateConfig)mapper.readValue(mapper.writeValueAsString((Object)config), ReplicateConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void negativeReplicateNumber() {
        try {
            new ReplicateConfig("", 0L, -1);
            Assert.fail((String)"Cannot create ReplicateConfig with negative replicateNumber");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void checkEquality(ReplicateConfig a, ReplicateConfig b) {
        Assert.assertEquals((long)a.getBlockId(), (long)b.getBlockId());
        Assert.assertEquals((long)a.getReplicas(), (long)b.getReplicas());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static ReplicateConfig createRandom() {
        Random random = new Random();
        String path = "/" + CommonUtils.randomAlphaNumString((int)(random.nextInt(10) + 1));
        ReplicateConfig config = new ReplicateConfig(path, random.nextLong(), random.nextInt(Integer.MAX_VALUE) + 1);
        return config;
    }
}

