/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfoTest;
import alluxio.util.CommonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class JobInfoTest {
    @Test
    public void json() throws Exception {
        JobInfo jobInfo = JobInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        JobInfo other = (JobInfo)mapper.readValue(mapper.writeValueAsBytes((Object)jobInfo), JobInfo.class);
        this.checkEquality(jobInfo, other);
    }

    public static JobInfo createRandom() {
        JobInfo result = new JobInfo();
        Random random = new Random();
        ArrayList taskInfoList = Lists.newArrayList();
        for (int i = 0; i < random.nextInt(10); ++i) {
            taskInfoList.add(TaskInfoTest.createRandom());
        }
        result.setTaskInfoList((List)taskInfoList);
        result.setErrorMessage(CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
        result.setJobId(random.nextLong());
        result.setResult(CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
        result.setStatus(Status.values()[random.nextInt(Status.values().length)]);
        return result;
    }

    public void checkEquality(JobInfo a, JobInfo b) {
        Assert.assertEquals((Object)a.getErrorMessage(), (Object)b.getErrorMessage());
        Assert.assertEquals((long)a.getJobId(), (long)b.getJobId());
        Assert.assertEquals((Object)a.getTaskInfoList(), (Object)b.getTaskInfoList());
        Assert.assertEquals((Object)a.getResult(), (Object)b.getResult());
        Assert.assertEquals((Object)a.getStatus(), (Object)b.getStatus());
    }
}

