/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.util.CommonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class TaskInfoTest {
    @Test
    public void jsonTest() throws Exception {
        TaskInfo taskInfo = TaskInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        TaskInfo other = (TaskInfo)mapper.readValue(mapper.writeValueAsBytes((Object)taskInfo), TaskInfo.class);
        this.checkEquality(taskInfo, other);
    }

    public static TaskInfo createRandom() {
        TaskInfo result = new TaskInfo();
        Random random = new Random();
        result.setErrorMessage(CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
        result.setStatus(Status.values()[random.nextInt(Status.values().length)]);
        result.setTaskId(random.nextInt());
        return result;
    }

    public void checkEquality(TaskInfo a, TaskInfo b) {
        Assert.assertEquals((Object)a.getErrorMessage(), (Object)b.getErrorMessage());
        Assert.assertEquals((Object)a.getStatus(), (Object)b.getStatus());
        Assert.assertEquals((long)a.getTaskId(), (long)b.getTaskId());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

