/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.meta;

import alluxio.job.JobConfig;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.util.CommonUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JobInfo
implements Comparable<JobInfo> {
    private final long mId;
    private final JobConfig mJobConfig;
    private final Map<Integer, TaskInfo> mTaskIdToInfo;
    private long mLastStatusChangeMs;
    private String mErrorMessage;
    private Status mStatus;
    private Function<JobInfo, Void> mStatusChangeCallback;
    private String mResult;

    public JobInfo(long id, JobConfig jobConfig, Function<JobInfo, Void> statusChangeCallback) {
        this.mId = id;
        this.mJobConfig = (JobConfig)Preconditions.checkNotNull((Object)jobConfig);
        this.mTaskIdToInfo = Maps.newHashMap();
        this.mLastStatusChangeMs = CommonUtils.getCurrentMs();
        this.mErrorMessage = "";
        this.mStatus = Status.CREATED;
        this.mStatusChangeCallback = statusChangeCallback;
    }

    @Override
    public synchronized int compareTo(JobInfo other) {
        return Long.compare(this.mLastStatusChangeMs, other.getLastStatusChangeMs());
    }

    public synchronized void addTask(int taskId) {
        Preconditions.checkArgument((!this.mTaskIdToInfo.containsKey(taskId) ? 1 : 0) != 0, (Object)"");
        this.mTaskIdToInfo.put(taskId, new TaskInfo().setJobId(this.mId).setTaskId(taskId).setStatus(Status.CREATED).setErrorMessage("").setResult(null));
    }

    public synchronized long getId() {
        return this.mId;
    }

    public synchronized JobConfig getJobConfig() {
        return this.mJobConfig;
    }

    public synchronized long getLastStatusChangeMs() {
        return this.mLastStatusChangeMs;
    }

    public synchronized void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage == null ? "" : errorMessage;
    }

    public synchronized String getErrorMessage() {
        return this.mErrorMessage;
    }

    public synchronized TaskInfo getTaskInfo(int taskId) {
        return this.mTaskIdToInfo.get(taskId);
    }

    public synchronized void setTaskInfo(int taskId, TaskInfo taskInfo) {
        this.mTaskIdToInfo.put(taskId, taskInfo);
    }

    public synchronized List<Integer> getTaskIdList() {
        return Lists.newArrayList(this.mTaskIdToInfo.keySet());
    }

    public synchronized void setStatus(Status status) {
        Status oldStatus = this.mStatus;
        this.mStatus = status;
        this.mLastStatusChangeMs = CommonUtils.getCurrentMs();
        if (this.mStatusChangeCallback != null && status != oldStatus) {
            this.mStatusChangeCallback.apply((Object)this);
        }
    }

    public synchronized Status getStatus() {
        return this.mStatus;
    }

    public synchronized void setResult(String result) {
        this.mResult = result;
    }

    public synchronized String getResult() {
        return this.mResult;
    }

    public synchronized List<TaskInfo> getTaskInfoList() {
        return Lists.newArrayList(this.mTaskIdToInfo.values());
    }
}

