/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.load;

import alluxio.job.load.LoadConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public final class LoadConfigTest {
    @Test
    public void jsonTest() throws Exception {
        LoadConfig config = new LoadConfig("/path/to/load", Integer.valueOf(3));
        ObjectMapper mapper = new ObjectMapper();
        LoadConfig other = (LoadConfig)mapper.readValue(mapper.writeValueAsString((Object)config), LoadConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void nullTest() {
        try {
            new LoadConfig(null, null);
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"The file path cannot be null", (Object)exception.getMessage());
        }
    }

    public void checkEquality(LoadConfig a, LoadConfig b) {
        Assert.assertEquals((Object)a.getFilePath(), (Object)b.getFilePath());
        Assert.assertEquals((long)a.getReplication(), (long)b.getReplication());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

