/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.job.wire.JobInfo;
import alluxio.job.wire.JobServiceSummary;
import alluxio.job.wire.Status;
import alluxio.job.wire.StatusSummary;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobServiceSummaryTest {
    JobServiceSummary mSummary;

    @Before
    public void before() {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        jobInfos.add(this.createJobInfo(1, Status.FAILED, 10003L));
        jobInfos.add(this.createJobInfo(2, Status.COMPLETED, 9998L));
        jobInfos.add(this.createJobInfo(3, Status.COMPLETED, 9999L));
        jobInfos.add(this.createJobInfo(4, Status.FAILED, 9997L));
        jobInfos.add(this.createJobInfo(5, Status.RUNNING, 10000L));
        jobInfos.add(this.createJobInfo(6, Status.FAILED, 10002L));
        this.mSummary = new JobServiceSummary(jobInfos);
    }

    @Test
    public void testJobServiceSummaryBuilder() {
        Collection summaryPerStatus = this.mSummary.getSummaryPerStatus();
        Assert.assertEquals((String)"Unexpected length of summaryPerStatus", (long)Status.values().length, (long)summaryPerStatus.size());
        HashMap groupByStatus = Maps.newHashMap();
        for (StatusSummary statusSummary : summaryPerStatus) {
            groupByStatus.put(statusSummary.getStatus(), statusSummary.getCount());
        }
        Assert.assertEquals((String)"Unexpected length after grouping by status, perhaps there were duplicate status in StatusSummary", (long)Status.values().length, (long)summaryPerStatus.size());
        block6: for (Status status : groupByStatus.keySet()) {
            long count = (Long)groupByStatus.get(status);
            switch (status) {
                case COMPLETED: {
                    Assert.assertEquals((String)"COMPLETED count unexpected", (long)2L, (long)count);
                    continue block6;
                }
                case FAILED: {
                    Assert.assertEquals((String)"FAILED count unexpected", (long)3L, (long)count);
                    continue block6;
                }
                case RUNNING: {
                    Assert.assertEquals((String)"RUNNING count unexpected", (long)1L, (long)count);
                    continue block6;
                }
            }
            Assert.assertEquals((String)("Unexpected status having count value: " + status), (long)0L, (long)count);
        }
    }

    @Test
    public void testRecentActivities() {
        List recentActivities = this.mSummary.getRecentActivities();
        Assert.assertEquals((String)"Unexpected length of recent activities", (long)6L, (long)recentActivities.size());
        JobInfo[] recentActvitiesArray = new JobInfo[6];
        recentActivities.toArray(recentActvitiesArray);
        Assert.assertEquals((long)1L, (long)recentActvitiesArray[0].getJobId());
        Assert.assertEquals((long)6L, (long)recentActvitiesArray[1].getJobId());
        Assert.assertEquals((long)5L, (long)recentActvitiesArray[2].getJobId());
        Assert.assertEquals((long)3L, (long)recentActvitiesArray[3].getJobId());
        Assert.assertEquals((long)2L, (long)recentActvitiesArray[4].getJobId());
        Assert.assertEquals((long)4L, (long)recentActvitiesArray[5].getJobId());
    }

    @Test
    public void testRecentFailures() {
        List recentFailures = this.mSummary.getRecentFailures();
        Assert.assertEquals((String)"Unexpected length of last activities", (long)3L, (long)recentFailures.size());
        JobInfo[] recentFailuresArray = new JobInfo[3];
        recentFailures.toArray(recentFailuresArray);
        Assert.assertEquals((long)1L, (long)recentFailuresArray[0].getJobId());
        Assert.assertEquals((long)6L, (long)recentFailuresArray[1].getJobId());
        Assert.assertEquals((long)4L, (long)recentFailuresArray[2].getJobId());
    }

    private JobInfo createJobInfo(int id, Status status, long lastStatusChangeMs) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setJobId((long)id);
        jobInfo.setStatus(status);
        jobInfo.setLastStatusChangeMs(lastStatusChangeMs);
        return jobInfo;
    }
}

