/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.composite;

import alluxio.job.JobConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CompositeConfig
implements JobConfig {
    private static final long serialVersionUID = 959533283484491854L;
    private static final String NAME = "Composite";
    private final ArrayList<JobConfig> mJobs;
    private final boolean mSequential;

    public CompositeConfig(@JsonProperty(value="jobs") ArrayList<JobConfig> jobs, @JsonProperty(value="sequential") Boolean sequential) {
        this.mJobs = (ArrayList)Preconditions.checkNotNull(jobs, (Object)"jobs");
        this.mSequential = sequential;
    }

    public ArrayList<JobConfig> getJobs() {
        return this.mJobs;
    }

    public boolean isSequential() {
        return this.mSequential;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompositeConfig)) {
            return false;
        }
        CompositeConfig that = (CompositeConfig)obj;
        return this.mJobs.equals(that.mJobs) && this.mSequential == that.mSequential;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mJobs, this.mSequential});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobs", this.mJobs).add("sequential", this.mSequential).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

