/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.transform;

public enum Format {
    CSV(".csv"),
    GZIP_CSV(".csv.gz"),
    GZIP(".gz"),
    PARQUET(".parquet");

    private String mSuffix;

    private Format(String suffix) {
        this.mSuffix = suffix;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public static boolean isCsv(String path) {
        return path.endsWith(CSV.getSuffix()) || path.endsWith(GZIP_CSV.getSuffix());
    }

    public static boolean isParquet(String path) {
        return path.endsWith(PARQUET.getSuffix());
    }

    public static boolean isGzipped(String path) {
        return path.endsWith(GZIP.getSuffix());
    }

    public static Format of(String path) {
        if (path.endsWith(CSV.getSuffix())) {
            return CSV;
        }
        if (path.endsWith(GZIP_CSV.getSuffix())) {
            return GZIP_CSV;
        }
        if (path.endsWith(PARQUET.getSuffix())) {
            return PARQUET;
        }
        throw new RuntimeException("Unsupported file format for " + path);
    }
}

