/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.transform;

import alluxio.job.transform.FieldSchema;
import alluxio.job.transform.Format;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class PartitionInfo
implements Serializable {
    private static final long serialVersionUID = 6905153658064056381L;
    private final String mSerdeClass;
    private final String mInputFormatClass;
    private final HashMap<String, String> mSerdeProperties;
    private final HashMap<String, String> mTableProperties;
    private final ArrayList<FieldSchema> mFields;

    public PartitionInfo(@JsonProperty(value="serdeClass") String serdeClass, @JsonProperty(value="inputFormatClass") String inputFormatClass, @JsonProperty(value="serdeProperties") HashMap<String, String> serdeProperties, @JsonProperty(value="tableProperties") HashMap<String, String> tableProperties, @JsonProperty(value="fields") ArrayList<FieldSchema> fields) {
        this.mSerdeClass = serdeClass;
        this.mInputFormatClass = inputFormatClass;
        this.mSerdeProperties = serdeProperties;
        this.mTableProperties = tableProperties;
        this.mFields = fields;
    }

    @JsonIgnore
    public Format getFormat(String filename) throws IOException {
        if (this.mSerdeClass.equals("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")) {
            return Format.PARQUET;
        }
        if (this.mSerdeClass.equals("org.apache.hadoop.hive.serde2.OpenCSVSerde") || this.mInputFormatClass.equals("org.apache.hadoop.mapred.TextInputFormat") && this.mSerdeProperties.containsKey("serialization.format")) {
            if (filename.endsWith(Format.GZIP.getSuffix())) {
                return Format.GZIP_CSV;
            }
            return Format.CSV;
        }
        throw new IOException("Cannot determine format for " + filename);
    }

    public String getInputFormatClass() {
        return this.mInputFormatClass;
    }

    public String getSerdeClass() {
        return this.mSerdeClass;
    }

    public HashMap<String, String> getSerdeProperties() {
        return this.mSerdeProperties;
    }

    public HashMap<String, String> getTableProperties() {
        return this.mTableProperties;
    }

    public ArrayList<FieldSchema> getFields() {
        return this.mFields;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartitionInfo)) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)obj;
        return this.mSerdeClass.equals(that.mSerdeClass) && this.mInputFormatClass.equals(that.mInputFormatClass) && this.mSerdeProperties.equals(that.mSerdeProperties) && this.mTableProperties.equals(that.mTableProperties) && this.mFields.equals(that.mFields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSerdeClass, this.mInputFormatClass, this.mSerdeProperties, this.mTableProperties, this.mFields});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serdeClass", (Object)this.mSerdeClass).add("inputFormatClass", (Object)this.mInputFormatClass).add("serdeProperties", this.mSerdeProperties).add("tableProperties", this.mTableProperties).add("fields", this.mFields).toString();
    }
}

