/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.grpc.JobInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JobInfo {
    private long mJobId;
    private String mName;
    private String mErrorMessage;
    private List<TaskInfo> mTaskInfoList;
    private Status mStatus;
    private String mResult;
    private long mLastStatusChangeMs;

    public JobInfo() {
    }

    public JobInfo(alluxio.job.meta.JobInfo jobInfo) {
        this.mJobId = jobInfo.getId();
        this.mName = jobInfo.getJobConfig().getName();
        this.mErrorMessage = jobInfo.getErrorMessage();
        this.mTaskInfoList = Lists.newArrayList();
        this.mStatus = Status.valueOf(jobInfo.getStatus().name());
        this.mResult = jobInfo.getResult();
        this.mLastStatusChangeMs = jobInfo.getLastStatusChangeMs();
        for (TaskInfo taskInfo : jobInfo.getTaskInfoList()) {
            this.mTaskInfoList.add(taskInfo);
        }
    }

    public JobInfo(alluxio.grpc.JobInfo jobInfo) throws IOException {
        this.mJobId = jobInfo.getId();
        this.mName = jobInfo.getName();
        this.mErrorMessage = jobInfo.getErrorMessage();
        this.mTaskInfoList = new ArrayList<TaskInfo>();
        for (alluxio.grpc.TaskInfo taskInfo : jobInfo.getTaskInfosList()) {
            this.mTaskInfoList.add(new TaskInfo(taskInfo));
        }
        this.mStatus = Status.valueOf(jobInfo.getStatus().name());
        this.mResult = jobInfo.getResult();
        this.mLastStatusChangeMs = jobInfo.getLastStatusChangeMs();
    }

    public void setJobId(long jobId) {
        this.mJobId = jobId;
    }

    public long getJobId() {
        return this.mJobId;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setResult(String result) {
        this.mResult = result;
    }

    public String getResult() {
        return this.mResult;
    }

    public void setStatus(Status status) {
        this.mStatus = status;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public void setTaskInfoList(List<TaskInfo> taskInfoList) {
        this.mTaskInfoList = (List)Preconditions.checkNotNull(taskInfoList);
    }

    public List<TaskInfo> getTaskInfoList() {
        return this.mTaskInfoList;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setLastStatusChangeMs(long lastStatusChangeMs) {
        this.mLastStatusChangeMs = lastStatusChangeMs;
    }

    public long getLastStatusChangeMs() {
        return this.mLastStatusChangeMs;
    }

    public alluxio.grpc.JobInfo toProto() throws IOException {
        ArrayList<alluxio.grpc.TaskInfo> taskInfos = new ArrayList<alluxio.grpc.TaskInfo>();
        for (TaskInfo taskInfo : this.mTaskInfoList) {
            taskInfos.add(taskInfo.toProto());
        }
        JobInfo.Builder jobInfoBuilder = alluxio.grpc.JobInfo.newBuilder().setId(this.mJobId).setErrorMessage(this.mErrorMessage).addAllTaskInfos(taskInfos).setStatus(this.mStatus.toProto()).setName(this.mName);
        if (this.mResult != null) {
            jobInfoBuilder.setResult(this.mResult);
        }
        jobInfoBuilder.setLastStatusChangeMs(this.mLastStatusChangeMs);
        return jobInfoBuilder.build();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobInfo)) {
            return false;
        }
        JobInfo that = (JobInfo)o;
        return Objects.equal((Object)this.mJobId, (Object)that.mJobId) && Objects.equal((Object)this.mErrorMessage, (Object)that.mErrorMessage) && Objects.equal(this.mTaskInfoList, that.mTaskInfoList) && Objects.equal((Object)((Object)this.mStatus), (Object)((Object)that.mStatus)) && Objects.equal((Object)this.mResult, (Object)that.mResult) && Objects.equal((Object)this.mLastStatusChangeMs, (Object)that.mLastStatusChangeMs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mJobId, this.mErrorMessage, this.mTaskInfoList, this.mStatus, this.mResult, this.mLastStatusChangeMs});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobId", this.mJobId).add("errorMessage", (Object)this.mErrorMessage).add("taskInfoList", this.mTaskInfoList).add("status", (Object)this.mStatus).add("result", (Object)this.mResult).add("lastStatusChangeMs", this.mLastStatusChangeMs).toString();
    }
}

