/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.TaskInfo;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.Status;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TaskInfo {
    private long mJobId;
    private int mTaskId;
    private Status mStatus;
    private String mErrorMessage;
    private Serializable mResult;

    public TaskInfo() {
    }

    public TaskInfo(alluxio.grpc.TaskInfo taskInfo) throws IOException {
        this.mJobId = taskInfo.getJobId();
        this.mTaskId = taskInfo.getTaskId();
        this.mStatus = Status.valueOf(taskInfo.getStatus().name());
        this.mErrorMessage = taskInfo.getErrorMessage();
        this.mResult = null;
        if (taskInfo.hasResult()) {
            try {
                this.mResult = SerializationUtils.deserialize(taskInfo.getResult().toByteArray());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentException((Throwable)e);
            }
        }
    }

    public long getJobId() {
        return this.mJobId;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public Serializable getResult() {
        return this.mResult;
    }

    public TaskInfo setJobId(long jobId) {
        this.mJobId = jobId;
        return this;
    }

    public TaskInfo setTaskId(int taskId) {
        this.mTaskId = taskId;
        return this;
    }

    public TaskInfo setStatus(Status status) {
        this.mStatus = status;
        return this;
    }

    public TaskInfo setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
        return this;
    }

    public TaskInfo setResult(byte[] result) {
        this.mResult = result == null ? null : Arrays.copyOf(result, result.length);
        return this;
    }

    public alluxio.grpc.TaskInfo toProto() throws IOException {
        ByteBuffer result = this.mResult == null ? null : ByteBuffer.wrap(SerializationUtils.serialize(this.mResult));
        TaskInfo.Builder taskInfoBuilder = alluxio.grpc.TaskInfo.newBuilder().setJobId(this.mJobId).setTaskId(this.mTaskId).setStatus(this.mStatus.toProto()).setErrorMessage(this.mErrorMessage);
        if (result != null) {
            taskInfoBuilder.setResult(ByteString.copyFrom((ByteBuffer)result));
        }
        return taskInfoBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo that = (TaskInfo)o;
        return Objects.equal((Object)this.mJobId, (Object)that.mJobId) && Objects.equal((Object)this.mTaskId, (Object)that.mTaskId) && Objects.equal((Object)((Object)this.mStatus), (Object)((Object)that.mStatus)) && Objects.equal((Object)this.mErrorMessage, (Object)that.mErrorMessage) && Objects.equal((Object)this.mResult, (Object)that.mResult);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mJobId, this.mTaskId, this.mStatus, this.mErrorMessage, this.mResult});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobId", this.mJobId).add("taskId", this.mTaskId).add("status", (Object)this.mStatus).add("errorMessage", (Object)this.mErrorMessage).add("result", (Object)this.mResult).toString();
    }
}

