/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.meta;

import alluxio.job.JobConfig;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.util.CommonUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JobInfo
implements Comparable<JobInfo> {
    private final long mId;
    private final JobConfig mJobConfig;
    private final ConcurrentHashMap<Integer, TaskInfo> mTaskIdToInfo;
    private final Consumer<JobInfo> mStatusChangeCallback;
    private volatile Status mStatus;
    private volatile long mLastStatusChangeMs;
    private volatile String mErrorMessage;
    private volatile String mResult;

    public JobInfo(long id, JobConfig jobConfig, Consumer<JobInfo> statusChangeCallback) {
        this.mId = id;
        this.mJobConfig = (JobConfig)Preconditions.checkNotNull((Object)jobConfig);
        this.mTaskIdToInfo = new ConcurrentHashMap(4, 0.95f);
        this.mLastStatusChangeMs = CommonUtils.getCurrentMs();
        this.mErrorMessage = "";
        this.mStatus = Status.CREATED;
        this.mStatusChangeCallback = statusChangeCallback;
    }

    @Override
    public int compareTo(JobInfo other) {
        int res = Long.compare(this.mLastStatusChangeMs, other.mLastStatusChangeMs);
        if (res != 0) {
            return res;
        }
        return Long.compare(this.mId, other.mId);
    }

    public void addTask(int taskId) {
        TaskInfo oldValue = this.mTaskIdToInfo.putIfAbsent(taskId, new TaskInfo().setJobId(this.mId).setTaskId(taskId).setStatus(Status.CREATED).setErrorMessage("").setResult(null));
        Preconditions.checkState((oldValue == null ? 1 : 0) != 0, (Object)String.format("JobId %d cannot add duplicate taskId %d", this.mId, taskId));
    }

    public long getId() {
        return this.mId;
    }

    public JobConfig getJobConfig() {
        return this.mJobConfig;
    }

    public long getLastStatusChangeMs() {
        return this.mLastStatusChangeMs;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage == null ? "" : errorMessage;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public TaskInfo getTaskInfo(int taskId) {
        return this.mTaskIdToInfo.get(taskId);
    }

    public void setTaskInfo(int taskId, TaskInfo taskInfo) {
        this.mTaskIdToInfo.put(taskId, taskInfo);
    }

    public List<Integer> getTaskIdList() {
        return Lists.newArrayList((Iterable)this.mTaskIdToInfo.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        JobInfo jobInfo = this;
        synchronized (jobInfo) {
            if (this.mStatus.isFinished()) {
                return;
            }
            Status oldStatus = this.mStatus;
            this.mStatus = status;
            this.mLastStatusChangeMs = CommonUtils.getCurrentMs();
            if (this.mStatusChangeCallback != null && status != oldStatus) {
                this.mStatusChangeCallback.accept(this);
            }
        }
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public void setResult(String result) {
        this.mResult = result;
    }

    public String getResult() {
        return this.mResult;
    }

    public List<TaskInfo> getTaskInfoList() {
        return Lists.newArrayList(this.mTaskIdToInfo.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobInfo)) {
            return false;
        }
        JobInfo other = (JobInfo)o;
        return Objects.equal((Object)this.mId, (Object)other.mId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId});
    }
}

