/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.transform;

import alluxio.job.JobConfig;
import alluxio.job.transform.PartitionInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CompactConfig
implements JobConfig {
    private static final long serialVersionUID = -3434270994964559796L;
    private static final String NAME = "Compact";
    private final PartitionInfo mPartitionInfo;
    private final String mInput;
    private final String mOutput;
    private final String mDatabaseType;
    private final int mNumFiles;

    public CompactConfig(@JsonProperty(value="partitionInfo") PartitionInfo partitionInfo, @JsonProperty(value="input") String input, @JsonProperty(value="output") String output, @JsonProperty(value="databaseType") String databaseType, @JsonProperty(value="numFiles") Integer numFiles) {
        this.mPartitionInfo = partitionInfo;
        this.mInput = (String)Preconditions.checkNotNull((Object)input, (Object)"input");
        this.mOutput = (String)Preconditions.checkNotNull((Object)output, (Object)"output");
        this.mDatabaseType = (String)Preconditions.checkNotNull((Object)databaseType, (Object)"databaseType");
        this.mNumFiles = (Integer)Preconditions.checkNotNull((Object)numFiles, (Object)"numFiles");
    }

    public PartitionInfo getPartitionInfo() {
        return this.mPartitionInfo;
    }

    public String getInput() {
        return this.mInput;
    }

    public String getOutput() {
        return this.mOutput;
    }

    public String getDatabaseType() {
        return this.mDatabaseType;
    }

    public int getNumFiles() {
        return this.mNumFiles;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompactConfig)) {
            return false;
        }
        CompactConfig that = (CompactConfig)obj;
        return this.mPartitionInfo.equals(that.mPartitionInfo) && this.mInput.equals(that.mInput) && this.mDatabaseType.equals(that.mDatabaseType) && this.mOutput.equals(that.mOutput) && this.mNumFiles == that.mNumFiles;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mPartitionInfo, this.mInput, this.mOutput, this.mDatabaseType, this.mNumFiles});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionInfo", (Object)this.mPartitionInfo).add("input", (Object)this.mInput).add("output", (Object)this.mOutput).add("databaseType", (Object)this.mDatabaseType).add("numFiles", this.mNumFiles).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

