/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.job.wire.JobInfo;
import alluxio.job.wire.JobServiceSummary;
import alluxio.job.wire.PlanInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.StatusSummary;
import alluxio.job.wire.WorkflowInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobServiceSummaryTest {
    JobServiceSummary mSummary;

    @Before
    public void before() {
        ArrayList<Object> jobInfos = new ArrayList<Object>();
        jobInfos.add(this.createPlanInfo(1, Status.FAILED, 10003L));
        jobInfos.add(this.createPlanInfo(2, Status.COMPLETED, 9998L));
        jobInfos.add(this.createPlanInfo(3, Status.COMPLETED, 9999L));
        jobInfos.add(this.createPlanInfo(4, Status.FAILED, 9997L));
        jobInfos.add(this.createPlanInfo(5, Status.RUNNING, 10000L));
        jobInfos.add(this.createPlanInfo(6, Status.FAILED, 10002L));
        jobInfos.add(this.createWorkflowInfo(7, Status.COMPLETED, 9996L));
        this.mSummary = new JobServiceSummary(jobInfos);
    }

    @Test
    public void testJobServiceSummaryBuilder() {
        Collection summaryPerStatus = this.mSummary.getSummaryPerStatus();
        Assert.assertEquals((String)"Unexpected length of summaryPerStatus", (long)Status.values().length, (long)summaryPerStatus.size());
        HashMap groupByStatus = Maps.newHashMap();
        for (StatusSummary statusSummary : summaryPerStatus) {
            groupByStatus.put(statusSummary.getStatus(), statusSummary.getCount());
        }
        Assert.assertEquals((String)"Unexpected length after grouping by status, perhaps there were duplicate status in StatusSummary", (long)Status.values().length, (long)summaryPerStatus.size());
        block6: for (Status status : groupByStatus.keySet()) {
            long count = (Long)groupByStatus.get(status);
            switch (status) {
                case COMPLETED: {
                    Assert.assertEquals((String)"COMPLETED count unexpected", (long)3L, (long)count);
                    continue block6;
                }
                case FAILED: {
                    Assert.assertEquals((String)"FAILED count unexpected", (long)3L, (long)count);
                    continue block6;
                }
                case RUNNING: {
                    Assert.assertEquals((String)"RUNNING count unexpected", (long)1L, (long)count);
                    continue block6;
                }
            }
            Assert.assertEquals((String)("Unexpected status having count value: " + status), (long)0L, (long)count);
        }
    }

    @Test
    public void testRecentActivities() {
        List recentActivities = this.mSummary.getRecentActivities();
        Assert.assertEquals((String)"Unexpected length of recent activities", (long)7L, (long)recentActivities.size());
        JobInfo[] recentActvitiesArray = new JobInfo[7];
        recentActivities.toArray(recentActvitiesArray);
        Assert.assertEquals((long)1L, (long)recentActvitiesArray[0].getId());
        Assert.assertEquals((long)6L, (long)recentActvitiesArray[1].getId());
        Assert.assertEquals((long)5L, (long)recentActvitiesArray[2].getId());
        Assert.assertEquals((long)3L, (long)recentActvitiesArray[3].getId());
        Assert.assertEquals((long)2L, (long)recentActvitiesArray[4].getId());
        Assert.assertEquals((long)4L, (long)recentActvitiesArray[5].getId());
        Assert.assertEquals((long)7L, (long)recentActvitiesArray[6].getId());
    }

    @Test
    public void testRecentFailures() {
        List recentFailures = this.mSummary.getRecentFailures();
        Assert.assertEquals((String)"Unexpected length of last activities", (long)3L, (long)recentFailures.size());
        JobInfo[] recentFailuresArray = new JobInfo[3];
        recentFailures.toArray(recentFailuresArray);
        Assert.assertEquals((long)1L, (long)recentFailuresArray[0].getId());
        Assert.assertEquals((long)6L, (long)recentFailuresArray[1].getId());
        Assert.assertEquals((long)4L, (long)recentFailuresArray[2].getId());
    }

    private PlanInfo createPlanInfo(int id, Status status, long lastStatusChangeMs) {
        return new PlanInfo((long)id, "test", status, lastStatusChangeMs, null);
    }

    private WorkflowInfo createWorkflowInfo(int id, Status status, long lastStatusChangeMs) {
        return new WorkflowInfo((long)id, "name", status, lastStatusChangeMs, "", (List)Lists.newArrayList());
    }
}

