/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform;

import alluxio.job.plan.PlanConfig;
import alluxio.job.plan.transform.PartitionInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CompactConfig
implements PlanConfig {
    private static final long serialVersionUID = -3434270994964559796L;
    private static final String NAME = "Compact";
    private final PartitionInfo mPartitionInfo;
    private final String mInput;
    private final String mOutput;
    private final String mDatabaseType;
    private final int mMaxNumFiles;
    private final long mMinFileSize;

    public CompactConfig(@JsonProperty(value="partitionInfo") PartitionInfo partitionInfo, @JsonProperty(value="input") String input, @JsonProperty(value="output") String output, @JsonProperty(value="databaseType") String databaseType, @JsonProperty(value="maxNumFiles") Integer maxNumFiles, @JsonProperty(value="minFileSize") Long minFileSize) {
        this.mPartitionInfo = partitionInfo;
        this.mInput = (String)Preconditions.checkNotNull((Object)input, (Object)"input");
        this.mOutput = (String)Preconditions.checkNotNull((Object)output, (Object)"output");
        this.mDatabaseType = (String)Preconditions.checkNotNull((Object)databaseType, (Object)"databaseType");
        this.mMaxNumFiles = (Integer)Preconditions.checkNotNull((Object)maxNumFiles, (Object)"maxNumFiles");
        this.mMinFileSize = (Long)Preconditions.checkNotNull((Object)minFileSize, (Object)"minFileSize");
    }

    public PartitionInfo getPartitionInfo() {
        return this.mPartitionInfo;
    }

    public String getInput() {
        return this.mInput;
    }

    public String getOutput() {
        return this.mOutput;
    }

    public String getDatabaseType() {
        return this.mDatabaseType;
    }

    public int getMaxNumFiles() {
        return this.mMaxNumFiles;
    }

    public long getMinFileSize() {
        return this.mMinFileSize;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompactConfig)) {
            return false;
        }
        CompactConfig that = (CompactConfig)obj;
        return this.mPartitionInfo.equals(that.mPartitionInfo) && this.mInput.equals(that.mInput) && this.mDatabaseType.equals(that.mDatabaseType) && this.mOutput.equals(that.mOutput) && this.mMaxNumFiles == that.mMaxNumFiles && this.mMinFileSize == that.mMinFileSize;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mPartitionInfo, this.mInput, this.mOutput, this.mDatabaseType, this.mMaxNumFiles, this.mMinFileSize});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("input", (Object)this.mInput).add("output", (Object)this.mOutput).add("databaseType", (Object)this.mDatabaseType).add("maxNumFiles", this.mMaxNumFiles).add("minFileSize", this.mMinFileSize).add("partitionInfo", (Object)this.mPartitionInfo).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

