/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.persist;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@JsonTypeName(value="Persist")
@ThreadSafe
public class PersistConfig
implements PlanConfig {
    private static final long serialVersionUID = -404303102995033014L;
    public static final String NAME = "Persist";
    private String mFilePath;
    private long mMountId;
    private final boolean mOverwrite;
    private String mUfsPath;

    @JsonCreator
    public PersistConfig(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="mountId") long mountId, @JsonProperty(value="overwrite") boolean overwrite, @JsonProperty(value="ufsPath") String ufsPath) {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)filePath, (Object)"The file path cannot be null");
        this.mMountId = (Long)Preconditions.checkNotNull((Object)mountId, (Object)"The mount ID cannot be null");
        this.mOverwrite = overwrite;
        this.mUfsPath = (String)Preconditions.checkNotNull((Object)ufsPath, (Object)"The UFS path cannot be null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public long getMountId() {
        return this.mMountId;
    }

    public String getUfsPath() {
        return this.mUfsPath;
    }

    public boolean isOverwrite() {
        return this.mOverwrite;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistConfig)) {
            return false;
        }
        PersistConfig that = (PersistConfig)obj;
        return Objects.equal((Object)this.mFilePath, (Object)that.mFilePath) && Objects.equal((Object)this.mMountId, (Object)that.mMountId) && Objects.equal((Object)this.mOverwrite, (Object)that.mOverwrite) && Objects.equal((Object)this.mUfsPath, (Object)that.mUfsPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFilePath, this.mMountId, this.mOverwrite, this.mUfsPath});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filePath", (Object)this.mFilePath).add("mountId", this.mMountId).add("overwrite", this.mOverwrite).add("ufsPath", (Object)this.mUfsPath).toString();
    }
}

