/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.meta;

import alluxio.job.JobConfig;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PlanInfo
implements Comparable<PlanInfo> {
    private final long mId;
    private final JobConfig mJobConfig;
    private final ConcurrentHashMap<Long, TaskInfo> mTaskIdToInfo;
    private final Consumer<PlanInfo> mStatusChangeCallback;
    private volatile Status mStatus;
    private volatile long mLastStatusChangeMs;
    private volatile String mErrorMessage;
    private volatile String mResult;

    public PlanInfo(long id, JobConfig jobConfig, Consumer<PlanInfo> statusChangeCallback) {
        this.mId = id;
        this.mJobConfig = (JobConfig)Preconditions.checkNotNull((Object)jobConfig);
        this.mTaskIdToInfo = new ConcurrentHashMap(4, 0.95f);
        this.mLastStatusChangeMs = CommonUtils.getCurrentMs();
        this.mErrorMessage = "";
        this.mStatus = Status.CREATED;
        this.mStatusChangeCallback = statusChangeCallback;
    }

    @Override
    public int compareTo(PlanInfo other) {
        int res = Long.compare(this.mLastStatusChangeMs, other.mLastStatusChangeMs);
        if (res != 0) {
            return res;
        }
        return Long.compare(this.mId, other.mId);
    }

    public void addTask(long taskId, WorkerInfo workerInfo, Object args) {
        TaskInfo oldValue = this.mTaskIdToInfo.putIfAbsent(taskId, new TaskInfo(this.mId, taskId, Status.CREATED, workerInfo.getAddress(), args));
        Preconditions.checkState((oldValue == null ? 1 : 0) != 0, (Object)String.format("JobId %d cannot add duplicate taskId %d", this.mId, taskId));
    }

    public long getId() {
        return this.mId;
    }

    public JobConfig getJobConfig() {
        return this.mJobConfig;
    }

    public long getLastStatusChangeMs() {
        return this.mLastStatusChangeMs;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage == null ? "" : errorMessage;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public TaskInfo getTaskInfo(long taskId) {
        return this.mTaskIdToInfo.get(taskId);
    }

    public void setTaskInfo(long taskId, TaskInfo taskInfo) {
        TaskInfo oldTaskInfo = this.mTaskIdToInfo.get(taskId);
        if (oldTaskInfo != null) {
            taskInfo.setDescription(oldTaskInfo.getDescription());
        }
        this.mTaskIdToInfo.put(taskId, taskInfo);
    }

    public List<Long> getTaskIdList() {
        return Lists.newArrayList((Iterable)this.mTaskIdToInfo.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        PlanInfo planInfo = this;
        synchronized (planInfo) {
            if (this.mStatus.isFinished()) {
                return;
            }
            Status oldStatus = this.mStatus;
            this.mStatus = status;
            this.mLastStatusChangeMs = CommonUtils.getCurrentMs();
            if (this.mStatusChangeCallback != null && status != oldStatus) {
                this.mStatusChangeCallback.accept(this);
            }
        }
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public void setResult(String result) {
        this.mResult = result;
    }

    public String getResult() {
        return this.mResult;
    }

    public List<TaskInfo> getTaskInfoList() {
        return Lists.newArrayList(this.mTaskIdToInfo.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanInfo)) {
            return false;
        }
        PlanInfo other = (PlanInfo)o;
        return Objects.equal((Object)this.mId, (Object)other.mId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId});
    }
}

