/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform;

import alluxio.job.plan.PlanConfig;
import alluxio.job.plan.transform.PartitionInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CompactConfig
implements PlanConfig {
    private static final long serialVersionUID = -3434270994964559796L;
    private static final String NAME = "Compact";
    private final PartitionInfo mInputPartitionInfo;
    private final String mInput;
    private final PartitionInfo mOutputPartitionInfo;
    private final String mOutput;
    private final int mMaxNumFiles;
    private final long mMinFileSize;

    public CompactConfig(@JsonProperty(value="inputPartitionInfo") PartitionInfo inputPartitionInfo, @JsonProperty(value="input") String input, @JsonProperty(value="outputPartitionInfo") PartitionInfo outputPartitionInfo, @JsonProperty(value="output") String output, @JsonProperty(value="maxNumFiles") Integer maxNumFiles, @JsonProperty(value="minFileSize") Long minFileSize) {
        this.mInputPartitionInfo = inputPartitionInfo;
        this.mInput = (String)Preconditions.checkNotNull((Object)input, (Object)"input");
        this.mOutputPartitionInfo = outputPartitionInfo;
        this.mOutput = (String)Preconditions.checkNotNull((Object)output, (Object)"output");
        this.mMaxNumFiles = (Integer)Preconditions.checkNotNull((Object)maxNumFiles, (Object)"maxNumFiles");
        this.mMinFileSize = (Long)Preconditions.checkNotNull((Object)minFileSize, (Object)"minFileSize");
    }

    public PartitionInfo getInputPartitionInfo() {
        return this.mInputPartitionInfo;
    }

    public PartitionInfo getOutputPartitionInfo() {
        return this.mOutputPartitionInfo;
    }

    public String getInput() {
        return this.mInput;
    }

    public String getOutput() {
        return this.mOutput;
    }

    public int getMaxNumFiles() {
        return this.mMaxNumFiles;
    }

    public long getMinFileSize() {
        return this.mMinFileSize;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompactConfig)) {
            return false;
        }
        CompactConfig that = (CompactConfig)obj;
        return this.mInputPartitionInfo.equals(that.mInputPartitionInfo) && this.mOutputPartitionInfo.equals(that.mOutputPartitionInfo) && this.mInput.equals(that.mInput) && this.mOutput.equals(that.mOutput) && this.mMaxNumFiles == that.mMaxNumFiles && this.mMinFileSize == that.mMinFileSize;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mInputPartitionInfo, this.mOutputPartitionInfo, this.mInput, this.mOutput, this.mMaxNumFiles, this.mMinFileSize});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("input", (Object)this.mInput).add("output", (Object)this.mOutput).add("maxNumFiles", this.mMaxNumFiles).add("minFileSize", this.mMinFileSize).add("inputPartitionInfo", (Object)this.mInputPartitionInfo).add("outputPartitionInfo", (Object)this.mOutputPartitionInfo).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

