/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@JsonTypeName(value="Evict")
@ThreadSafe
public final class EvictConfig
implements PlanConfig {
    private static final long serialVersionUID = 931006961650512841L;
    public static final String NAME = "Evict";
    private long mBlockId;
    private int mReplicas;

    @JsonCreator
    public EvictConfig(@JsonProperty(value="blockId") long blockId, @JsonProperty(value="replicas") int replicas) {
        Preconditions.checkArgument((replicas > 0 ? 1 : 0) != 0, (Object)"replicas must be positive.");
        this.mBlockId = blockId;
        this.mReplicas = replicas;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public int getReplicas() {
        return this.mReplicas;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EvictConfig)) {
            return false;
        }
        EvictConfig that = (EvictConfig)obj;
        return Objects.equal((Object)this.mBlockId, (Object)that.mBlockId) && Objects.equal((Object)this.mReplicas, (Object)that.mReplicas);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mBlockId, this.mReplicas});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockId", this.mBlockId).add("replicas", this.mReplicas).toString();
    }
}

