/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.grpc.JobInfo;
import alluxio.grpc.JobType;
import alluxio.job.ProtoUtils;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowInfo
implements JobInfo {
    private final long mId;
    private final String mName;
    private final Status mStatus;
    private final long mLastUpdated;
    private final String mErrorMessage;
    private final List<JobInfo> mChildren;

    public WorkflowInfo(long id, String name, Status status, long lastUpdated, String errorMessage, List<JobInfo> children) {
        this.mId = id;
        this.mName = name;
        this.mStatus = status;
        this.mLastUpdated = lastUpdated;
        this.mErrorMessage = errorMessage == null ? "" : errorMessage;
        this.mChildren = children;
    }

    public WorkflowInfo(alluxio.grpc.JobInfo jobInfo) throws IOException {
        Preconditions.checkArgument((boolean)jobInfo.getType().equals((Object)JobType.WORKFLOW), (Object)"Invalid type");
        this.mId = jobInfo.getId();
        this.mName = jobInfo.getName();
        this.mStatus = Status.valueOf(jobInfo.getStatus().name());
        this.mLastUpdated = jobInfo.getLastUpdated();
        this.mErrorMessage = jobInfo.getErrorMessage();
        this.mChildren = Lists.newArrayList();
        for (alluxio.grpc.JobInfo childJobInfo : jobInfo.getChildrenList()) {
            this.mChildren.add(ProtoUtils.fromProto(childJobInfo));
        }
    }

    @Override
    public long getId() {
        return this.mId;
    }

    @Override
    @Nullable
    public Long getParentId() {
        return null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.mName;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "";
    }

    @Override
    @Nonnull
    public Status getStatus() {
        return this.mStatus;
    }

    @Override
    public long getLastUpdated() {
        return this.mLastUpdated;
    }

    @Override
    @Nonnull
    public List<JobInfo> getChildren() {
        return Collections.unmodifiableList(this.mChildren);
    }

    @Override
    @Nullable
    public Serializable getResult() {
        return null;
    }

    @Override
    @Nonnull
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @Override
    @Nonnull
    public alluxio.grpc.JobInfo toProto() throws IOException {
        JobInfo.Builder builder = alluxio.grpc.JobInfo.newBuilder().setId(this.mId).setName(this.mName).setStatus(this.mStatus.toProto()).setLastUpdated(this.mLastUpdated).setErrorMessage(this.mErrorMessage).setType(JobType.WORKFLOW);
        for (JobInfo child : this.mChildren) {
            builder.addChildren(child.toProto());
        }
        return builder.build();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mStatus, this.mLastUpdated, this.mChildren});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkflowInfo)) {
            return false;
        }
        WorkflowInfo that = (WorkflowInfo)o;
        return Objects.equal((Object)this.mId, (Object)that.mId) && Objects.equal(this.mChildren, that.mChildren) && Objects.equal((Object)((Object)this.mStatus), (Object)((Object)that.mStatus)) && Objects.equal((Object)this.mLastUpdated, (Object)that.mLastUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.mId).add("status", (Object)this.mStatus).add("lastUpdated", this.mLastUpdated).add("children", this.mChildren).toString();
    }
}

