/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

@JsonTypeName(value="Move")
@ThreadSafe
public final class MoveConfig
implements PlanConfig {
    private static final long serialVersionUID = -5198319303173120739L;
    public static final String NAME = "Move";
    private String mPath;
    private long mBlockId;
    private String mMediumType;
    private String mWorkerHost;

    @JsonCreator
    public MoveConfig(@JsonProperty(value="path") String path, @JsonProperty(value="blockId") long blockId, @JsonProperty(value="workerHost") String workerHost, @JsonProperty(value="mediumType") String mediumType) {
        this.mPath = path;
        this.mBlockId = blockId;
        this.mMediumType = mediumType;
        this.mWorkerHost = workerHost;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<String> affectedPaths() {
        if (StringUtils.isEmpty((CharSequence)this.mPath)) {
            return ImmutableList.of((Object)this.mPath);
        }
        return Collections.EMPTY_LIST;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public String getMediumType() {
        return this.mMediumType;
    }

    public String getWorkerHost() {
        return this.mWorkerHost;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MoveConfig)) {
            return false;
        }
        MoveConfig that = (MoveConfig)obj;
        return Objects.equal((Object)this.mBlockId, (Object)that.mBlockId) && Objects.equal((Object)this.mWorkerHost, (Object)that.mWorkerHost) && Objects.equal((Object)this.mMediumType, (Object)that.mMediumType) && Objects.equal((Object)this.mPath, (Object)that.mPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mBlockId, this.mMediumType, this.mWorkerHost});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockId", this.mBlockId).add("mediumType", (Object)this.mMediumType).add("workerHost", (Object)this.mWorkerHost).add("path", (Object)this.mPath).toString();
    }
}

