/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.load;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LoadConfig
implements PlanConfig {
    public static final String NAME = "Load";
    private static final long serialVersionUID = -7937106659935180792L;
    private final String mFilePath;
    private final int mReplication;

    public LoadConfig(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="replication") Integer replication) {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)filePath, (Object)"The file path cannot be null");
        this.mReplication = replication == null ? 1 : replication;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public int getReplication() {
        return this.mReplication;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LoadConfig)) {
            return false;
        }
        LoadConfig that = (LoadConfig)obj;
        return this.mFilePath.equals(that.mFilePath) && this.mReplication == that.mReplication;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFilePath, this.mReplication});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("FilePath", (Object)this.mFilePath).add("Replication", this.mReplication).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<String> affectedPaths() {
        return ImmutableList.of((Object)this.mFilePath);
    }
}

