/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.JobInfo;
import alluxio.grpc.JobType;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class PlanInfo
implements JobInfo {
    private final long mId;
    private final String mName;
    private final String mDescription;
    private final String mErrorType;
    private final String mErrorMessage;
    private final List<JobInfo> mChildren;
    private final Status mStatus;
    private final String mResult;
    private final long mLastUpdated;
    private final List<String> mAffectedPaths;

    public PlanInfo(long id, String name, Status status, long lastUpdated, @Nullable String errorMessage) {
        this.mId = id;
        this.mName = name;
        this.mDescription = "";
        this.mStatus = status;
        this.mLastUpdated = lastUpdated;
        this.mErrorType = "";
        this.mErrorMessage = errorMessage == null ? "" : errorMessage;
        this.mChildren = ImmutableList.of();
        this.mResult = null;
        this.mAffectedPaths = ImmutableList.of();
    }

    public PlanInfo(alluxio.job.plan.meta.PlanInfo planInfo, boolean verbose) {
        this.mId = planInfo.getId();
        this.mName = planInfo.getJobConfig().getName();
        this.mDescription = verbose ? planInfo.getJobConfig().toString() : "";
        this.mErrorType = planInfo.getErrorType();
        this.mErrorMessage = planInfo.getErrorMessage();
        this.mStatus = Status.valueOf(planInfo.getStatus().name());
        this.mResult = verbose ? planInfo.getResult() : "";
        this.mLastUpdated = planInfo.getLastStatusChangeMs();
        this.mChildren = Lists.newArrayList();
        if (verbose) {
            for (TaskInfo taskInfo : planInfo.getTaskInfoList()) {
                this.mChildren.add(taskInfo);
            }
        }
        this.mAffectedPaths = ImmutableList.copyOf(planInfo.getJobConfig().affectedPaths());
    }

    public PlanInfo(alluxio.grpc.JobInfo jobInfo) throws IOException {
        Preconditions.checkArgument((boolean)jobInfo.getType().equals((Object)JobType.PLAN), (Object)"Invalid type");
        this.mId = jobInfo.getId();
        this.mName = jobInfo.getName();
        this.mDescription = jobInfo.getDescription();
        this.mErrorType = jobInfo.getErrorType();
        this.mErrorMessage = jobInfo.getErrorMessage();
        this.mChildren = new ArrayList<JobInfo>();
        for (alluxio.grpc.JobInfo taskInfo : jobInfo.getChildrenList()) {
            this.mChildren.add(new TaskInfo(taskInfo));
        }
        this.mStatus = Status.valueOf(jobInfo.getStatus().name());
        if (jobInfo.hasResult()) {
            try {
                this.mResult = SerializationUtils.deserialize(jobInfo.getResult().toByteArray()).toString();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentException((Throwable)e);
            }
        } else {
            this.mResult = null;
        }
        this.mLastUpdated = jobInfo.getLastUpdated();
        this.mAffectedPaths = new ArrayList<String>();
        for (String path : jobInfo.getAffectedPathsList()) {
            this.mAffectedPaths.add(path);
        }
    }

    @Override
    public Long getParentId() {
        return null;
    }

    @Override
    public long getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    public String getResult() {
        return this.mResult;
    }

    @Override
    public Status getStatus() {
        return this.mStatus;
    }

    @Override
    public List<JobInfo> getChildren() {
        return this.mChildren;
    }

    @Override
    public String getErrorType() {
        return this.mErrorType;
    }

    @Override
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @Override
    public long getLastUpdated() {
        return this.mLastUpdated;
    }

    public List<String> getAffectedPaths() {
        return ImmutableList.copyOf(this.mAffectedPaths);
    }

    @Override
    public alluxio.grpc.JobInfo toProto() throws IOException {
        ArrayList<alluxio.grpc.JobInfo> taskInfos = new ArrayList<alluxio.grpc.JobInfo>();
        for (JobInfo taskInfo : this.mChildren) {
            taskInfos.add(taskInfo.toProto());
        }
        JobInfo.Builder jobInfoBuilder = alluxio.grpc.JobInfo.newBuilder().setId(this.mId).setErrorMessage(this.mErrorMessage).addAllChildren(taskInfos).setStatus(this.mStatus.toProto()).setName(this.mName).setDescription(this.mDescription).addAllAffectedPaths(this.mAffectedPaths).setErrorType(this.mErrorType).setType(JobType.PLAN);
        if (this.mResult != null && !this.mResult.isEmpty()) {
            ByteBuffer result = this.mResult == null ? null : ByteBuffer.wrap(SerializationUtils.serialize(this.mResult));
            jobInfoBuilder.setResult(ByteString.copyFrom((ByteBuffer)result));
        }
        jobInfoBuilder.setLastUpdated(this.mLastUpdated);
        return jobInfoBuilder.build();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanInfo)) {
            return false;
        }
        PlanInfo that = (PlanInfo)o;
        return Objects.equal((Object)this.mId, (Object)that.mId) && Objects.equal((Object)this.mErrorType, (Object)that.mErrorType) && Objects.equal((Object)this.mErrorMessage, (Object)that.mErrorMessage) && Objects.equal(this.mChildren, that.mChildren) && Objects.equal((Object)((Object)this.mStatus), (Object)((Object)that.mStatus)) && Objects.equal((Object)this.mResult, (Object)that.mResult) && Objects.equal((Object)this.mLastUpdated, (Object)that.mLastUpdated) && Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mDescription, (Object)that.mDescription);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mErrorMessage, this.mChildren, this.mStatus, this.mResult, this.mLastUpdated, this.mName, this.mDescription});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.mId).add("errorType", (Object)this.mErrorType).add("errorMessage", (Object)this.mErrorMessage).add("childPlanInfoList", this.mChildren).add("status", (Object)this.mStatus).add("result", (Object)this.mResult).add("lastUpdated", this.mLastUpdated).add("name", (Object)this.mName).add("description", (Object)this.mDescription).toString();
    }
}

