/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class TimeSeries
implements Serializable {
    private static final long serialVersionUID = -9139286113871170329L;
    private final long mWidthNano;
    private TreeMap<Long, Integer> mSeries = new TreeMap();

    public TimeSeries(long widthNano) {
        this.mWidthNano = widthNano;
    }

    public TimeSeries() {
        this.mWidthNano = 1000000000L;
    }

    public void record(long timeNano) {
        this.record(timeNano, 1);
    }

    public void record(long timeNano, int numEvents) {
        long leftEndPoint = this.bucket(timeNano);
        this.mSeries.put(leftEndPoint, this.mSeries.getOrDefault(leftEndPoint, 0) + numEvents);
    }

    public int get(long timeNano) {
        long leftEndPoint = this.bucket(timeNano);
        return this.mSeries.getOrDefault(leftEndPoint, 0);
    }

    public long getWidthNano() {
        return this.mWidthNano;
    }

    public TreeMap<Long, Integer> getSeries() {
        return this.mSeries;
    }

    public void add(TimeSeries other) {
        TreeMap<Long, Integer> otherSeries = other.getSeries();
        for (Map.Entry<Long, Integer> event : otherSeries.entrySet()) {
            this.record(event.getKey() + other.getWidthNano() / 2L, event.getValue());
        }
    }

    public Summary getSummary() {
        Summary summary = new Summary();
        if (this.mSeries.isEmpty()) {
            return summary;
        }
        for (Integer value : this.mSeries.values()) {
            summary.mMean += (double)value.intValue();
            summary.mPeak = Math.max(summary.mPeak, (double)value.intValue());
        }
        long totalTime = (this.mSeries.lastKey() - this.mSeries.firstKey()) / this.mWidthNano + 1L;
        summary.mMean /= (double)totalTime;
        for (Integer value : this.mSeries.values()) {
            summary.mStddev += ((double)value.intValue() - summary.mMean) * ((double)value.intValue() - summary.mMean);
        }
        summary.mStddev += summary.mMean * summary.mMean * (double)(totalTime - (long)this.mSeries.size());
        summary.mStddev /= (double)totalTime;
        summary.mStddev = Math.sqrt(summary.mStddev);
        return summary;
    }

    public String toString() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        this.print(printStream);
        printStream.close();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputStream.toString();
    }

    public void sparsePrint(PrintStream stream) {
        if (this.mSeries.isEmpty()) {
            return;
        }
        long start = this.mSeries.firstKey();
        stream.printf("Time series starts at %d with width %d.%n", start, this.mWidthNano);
        for (Map.Entry<Long, Integer> entry : this.mSeries.entrySet()) {
            stream.printf("%d %d%n", (entry.getKey() - start) / this.mWidthNano, entry.getValue());
        }
    }

    public void print(PrintStream stream) {
        if (this.mSeries.isEmpty()) {
            return;
        }
        long start = this.mSeries.firstKey();
        stream.printf("Time series starts at %d with width %d.%n", start, this.mWidthNano);
        int bucketIndex = 0;
        Iterator<Map.Entry<Long, Integer>> it = this.mSeries.entrySet().iterator();
        Map.Entry<Long, Integer> current = it.next();
        while (current != null) {
            int numEvents = 0;
            if ((long)bucketIndex * this.mWidthNano + start == current.getKey()) {
                numEvents = current.getValue();
                current = null;
                if (it.hasNext()) {
                    current = it.next();
                }
            }
            stream.printf("%d %d%n", bucketIndex, numEvents);
            ++bucketIndex;
        }
    }

    private long bucket(long timeNano) {
        return timeNano / this.mWidthNano * this.mWidthNano;
    }

    public class Summary {
        public double mMean = 0.0;
        public double mPeak = 0.0;
        public double mStddev = 0.0;
    }
}

