/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.persist;

import alluxio.job.plan.persist.PersistConfig;
import alluxio.util.CommonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class PersistConfigTest {
    @Test
    public void jsonTest() throws Exception {
        PersistConfig config = PersistConfigTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        PersistConfig other = (PersistConfig)mapper.readValue(mapper.writeValueAsString((Object)config), PersistConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void nullTest() {
        try {
            new PersistConfig(null, -1L, true, "");
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"The file path cannot be null", (Object)exception.getMessage());
        }
    }

    public static PersistConfig createRandom() {
        Random random = new Random();
        String path = "/" + CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String ufsPath = "/" + CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        long mountId = random.nextLong();
        return new PersistConfig(path, mountId, random.nextBoolean(), ufsPath);
    }

    public void checkEquality(PersistConfig a, PersistConfig b) {
        Assert.assertEquals((Object)a.getFilePath(), (Object)b.getFilePath());
        Assert.assertEquals((Object)a.getUfsPath(), (Object)b.getUfsPath());
        Assert.assertEquals((long)a.getMountId(), (long)b.getMountId());
        Assert.assertEquals((Object)a.isOverwrite(), (Object)b.isOverwrite());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

