/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.load;

import alluxio.job.plan.load.LoadConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public final class LoadConfigTest {
    @Test
    public void jsonTest() throws Exception {
        LoadConfig config = new LoadConfig("/path/to/load", Integer.valueOf(3), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(true));
        ObjectMapper mapper = new ObjectMapper();
        LoadConfig other = (LoadConfig)mapper.readValue(mapper.writeValueAsString((Object)config), LoadConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void nullTest() {
        try {
            new LoadConfig(null, null, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(true));
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"The file path cannot be null", (Object)exception.getMessage());
        }
    }

    public void checkEquality(LoadConfig a, LoadConfig b) {
        Assert.assertEquals((Object)a.getFilePath(), (Object)b.getFilePath());
        Assert.assertEquals((long)a.getReplication(), (long)b.getReplication());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

