/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.migrate;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MigrateConfig
implements PlanConfig {
    private static final long serialVersionUID = 8014674802258120190L;
    public static final String NAME = "Migrate";
    private final String mSource;
    private final String mDestination;
    private final String mWriteType;
    private final boolean mOverwrite;

    public MigrateConfig(@JsonProperty(value="source") String source, @JsonProperty(value="destination") String dst, @JsonProperty(value="writeType") String writeType, @JsonProperty(value="overwrite") boolean overwrite) {
        this.mSource = (String)Preconditions.checkNotNull((Object)source, (Object)"source must be set");
        this.mDestination = (String)Preconditions.checkNotNull((Object)dst, (Object)"destination must be set");
        this.mWriteType = writeType;
        this.mOverwrite = overwrite;
    }

    public String getSource() {
        return this.mSource;
    }

    public String getDestination() {
        return this.mDestination;
    }

    public String getWriteType() {
        return this.mWriteType;
    }

    public boolean isOverwrite() {
        return this.mOverwrite;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MigrateConfig)) {
            return false;
        }
        MigrateConfig that = (MigrateConfig)obj;
        return Objects.equal((Object)this.mSource, (Object)that.mSource) && Objects.equal((Object)this.mDestination, (Object)that.mDestination) && Objects.equal((Object)this.mWriteType, (Object)that.mWriteType) && Objects.equal((Object)this.mOverwrite, (Object)that.mOverwrite);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSource, this.mDestination, this.mWriteType, this.mOverwrite});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.mSource).add("destination", (Object)this.mDestination).add("writeType", (Object)this.mWriteType).add("overwrite", this.mOverwrite).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<String> affectedPaths() {
        return ImmutableList.of((Object)this.mSource, (Object)this.mDestination);
    }
}

