/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.job.plan.replicate.SetReplicaConfig;
import alluxio.util.CommonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class SetReplicaConfigTest {
    @Test
    public void json() throws Exception {
        SetReplicaConfig config = SetReplicaConfigTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        SetReplicaConfig other = (SetReplicaConfig)mapper.readValue(mapper.writeValueAsString((Object)config), SetReplicaConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void negativeReplicateNumber() {
        try {
            new SetReplicaConfig("", 0L, -1);
            Assert.fail((String)"Cannot create ReplicateConfig with negative replicateNumber");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void checkEquality(SetReplicaConfig a, SetReplicaConfig b) {
        Assert.assertEquals((long)a.getBlockId(), (long)b.getBlockId());
        Assert.assertEquals((long)a.getReplicas(), (long)b.getReplicas());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static SetReplicaConfig createRandom() {
        Random random = new Random();
        String path = "/" + CommonUtils.randomAlphaNumString((int)(random.nextInt(10) + 1));
        SetReplicaConfig config = new SetReplicaConfig(path, random.nextLong(), random.nextInt(Integer.MAX_VALUE) + 1);
        return config;
    }
}

