/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.cmd.migrate;

import alluxio.client.WriteType;
import alluxio.job.cmd.migrate.MigrateCliConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class MigrateCliConfigTest {
    @Test
    public void jsonTest() throws Exception {
        MigrateCliConfig config = new MigrateCliConfig("/path/from", "/path/to", WriteType.THROUGH, true, 2);
        ObjectMapper mapper = new ObjectMapper();
        MigrateCliConfig other = (MigrateCliConfig)mapper.readValue(mapper.writeValueAsString((Object)config), MigrateCliConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void nullTest() {
        try {
            new MigrateCliConfig(null, "dst", WriteType.THROUGH, true, 1);
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"source must be set", (Object)exception.getMessage());
        }
        try {
            new MigrateCliConfig("src", null, WriteType.THROUGH, true, 1);
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"destination must be set", (Object)exception.getMessage());
        }
    }

    public void checkEquality(MigrateCliConfig a, MigrateCliConfig b) {
        Assert.assertEquals((Object)a.getSource(), (Object)b.getSource());
        Assert.assertEquals((Object)a.getDestination(), (Object)b.getDestination());
        Assert.assertEquals((Object)a.getOperationType(), (Object)b.getOperationType());
        Assert.assertEquals((Object)a.getJobSource(), (Object)b.getJobSource());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

