/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.cmd.load;

import alluxio.job.cmd.load.LoadCliConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class LoadCliConfigTest {
    @Test
    public void jsonTest() throws Exception {
        LoadCliConfig config = new LoadCliConfig("/path/to/load", Integer.valueOf(3), Integer.valueOf(1), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, true);
        ObjectMapper mapper = new ObjectMapper();
        LoadCliConfig other = (LoadCliConfig)mapper.readValue(mapper.writeValueAsString((Object)config), LoadCliConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void nullTest() {
        try {
            new LoadCliConfig(null, null, null, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, true);
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"The file path cannot be null", (Object)exception.getMessage());
        }
    }

    public void checkEquality(LoadCliConfig a, LoadCliConfig b) {
        Assert.assertEquals((Object)a.getFilePath(), (Object)b.getFilePath());
        Assert.assertEquals((long)a.getReplication(), (long)b.getReplication());
        Assert.assertEquals((Object)a.getJobSource(), (Object)b.getJobSource());
        Assert.assertEquals((Object)a.getOperationType(), (Object)b.getOperationType());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

