/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.util;

import alluxio.job.util.TimeSeries;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;

public final class TimeSeriesTest {
    private long mBase = 1234569000000000L;

    @Test
    public void recordTest() {
        TimeSeries timeSeries = new TimeSeries();
        timeSeries.record(this.mBase + 10000000000L);
        timeSeries.record(this.mBase + 10000000000L + 1L);
        timeSeries.record(this.mBase + 10000000000L + 2L);
        timeSeries.record(this.mBase + 13000000000L);
        Assert.assertEquals((long)3L, (long)timeSeries.get(this.mBase + 10000000000L + 3L));
        Assert.assertEquals((long)1L, (long)timeSeries.get(this.mBase + 13000000000L));
        Assert.assertEquals((long)0L, (long)timeSeries.get(this.mBase + 12000000000L));
        Assert.assertEquals((long)0L, (long)timeSeries.get(this.mBase + 11000000000L));
    }

    @Test
    public void summaryTest() {
        TimeSeries timeSeries = new TimeSeries();
        timeSeries.record(this.mBase + 10000000000L);
        timeSeries.record(this.mBase + 10000000000L + 1L);
        timeSeries.record(this.mBase + 12000000000L + 1L);
        TimeSeries.Summary summary = timeSeries.getSummary();
        Assert.assertEquals((double)1.0, (double)summary.mMean, (double)1.0E-6);
        Assert.assertEquals((double)2.0, (double)summary.mPeak, (double)1.0E-6);
        Assert.assertEquals((double)Math.sqrt(0.6666666666666666), (double)summary.mStddev, (double)1.0E-6);
    }

    @Test
    public void printTest() {
        TimeSeries timeSeries = new TimeSeries();
        timeSeries.record(this.mBase);
        timeSeries.record(this.mBase + 8000000000L);
        timeSeries.record(this.mBase + 8000000000L + 1L);
        timeSeries.record(this.mBase + 9000000000L + 1L);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        timeSeries.print(printStream);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Time series starts at %d with width %d.%n", this.mBase, 1000000000L));
        sb.append(String.format("%d %d%n", 0, 1));
        for (int i = 1; i < 8; ++i) {
            sb.append(String.format("%d %d%n", i, 0));
        }
        sb.append(String.format("%d %d%n", 8, 2));
        sb.append(String.format("%d %d%n", 9, 1));
        printStream.close();
        Assert.assertEquals((Object)sb.toString(), (Object)outputStream.toString());
    }

    @Test
    public void sparsePrintTest() {
        TimeSeries timeSeries = new TimeSeries();
        timeSeries.record(this.mBase);
        timeSeries.record(this.mBase + 8000000000L);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        timeSeries.sparsePrint(printStream);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Time series starts at %d with width %d.%n", this.mBase, 1000000000L));
        sb.append(String.format("%d %d%n", 0, 1));
        sb.append(String.format("%d %d%n", 8, 1));
        Assert.assertEquals((Object)sb.toString(), (Object)outputStream.toString());
    }
}

