/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow.composite;

import alluxio.job.JobConfig;
import alluxio.job.plan.load.LoadConfig;
import alluxio.job.plan.transform.CompactConfig;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.job.util.SerializationUtils;
import alluxio.job.workflow.composite.CompositeConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public final class CompositeConfigTest {
    private static final CompositeConfig CONFIG;

    @Test
    public void jsonTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        CompositeConfig other = (CompositeConfig)mapper.readValue(mapper.writeValueAsString((Object)CONFIG), CompositeConfig.class);
        Assert.assertEquals((Object)CONFIG, (Object)other);
    }

    @Test
    public void javaSerializationTest() throws Exception {
        byte[] bytes = SerializationUtils.serialize((Object)CONFIG);
        TestCase.assertNotNull((Object)bytes);
        Serializable deserialized = SerializationUtils.deserialize((byte[])bytes);
        Assert.assertEquals(CompositeConfig.class, deserialized.getClass());
        Assert.assertEquals((Object)CONFIG, (Object)deserialized);
    }

    static {
        PartitionInfo pInfo = new PartitionInfo("serde", "inputformat", new HashMap(), new HashMap(), new ArrayList());
        ArrayList<Object> jobs = new ArrayList<Object>();
        jobs.add(new CompositeConfig(new ArrayList(), Boolean.valueOf(true)));
        jobs.add(new CompositeConfig(new ArrayList(), Boolean.valueOf(false)));
        jobs.add(new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new LoadConfig("/", Integer.valueOf(1), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(true))}), Boolean.valueOf(true)));
        jobs.add(new CompactConfig(pInfo, "/input", pInfo, "/output", Integer.valueOf(100), Long.valueOf(0x40000000L)));
        CONFIG = new CompositeConfig(jobs, Boolean.valueOf(true));
    }
}

