/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BatchedJobConfig
implements PlanConfig {
    public static final String NAME = "BatchedJob";
    private static final long serialVersionUID = -5482449086646391059L;
    private final String mJobType;
    private final Set<Map<String, String>> mJobConfigs;

    public BatchedJobConfig(@JsonProperty(value="jobType") String jobType, @JsonProperty(value="jobConfig") Set<Map<String, String>> jobConfigs) {
        this.mJobType = (String)Preconditions.checkNotNull((Object)jobType, (Object)"The file path cannot be null");
        this.mJobConfigs = (Set)Preconditions.checkNotNull(jobConfigs, (Object)"The job config cannot be null");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BatchedJobConfig)) {
            return false;
        }
        BatchedJobConfig that = (BatchedJobConfig)obj;
        return this.mJobType.equals(that.mJobType) && this.mJobConfigs == that.mJobConfigs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mJobType, this.mJobConfigs});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("JobType", (Object)this.mJobType).add("JobConfigs", this.mJobConfigs).toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<String> affectedPaths() {
        return Collections.EMPTY_LIST;
    }

    public String getJobType() {
        return this.mJobType;
    }

    public Set<Map<String, String>> getJobConfigs() {
        return this.mJobConfigs;
    }
}

