/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SleepJobConfig
implements PlanConfig {
    private static final long serialVersionUID = 43139051130518451L;
    public static final String NAME = "Sleep";
    private final long mTimeMs;
    private final int mTasksPerWorker;

    public SleepJobConfig(long timeMs) {
        this(timeMs, 1);
    }

    public SleepJobConfig(@JsonProperty(value="timeMs") long timeMs, @JsonProperty(value="tasksPerWorker") int tasksPerWorker) {
        this.mTimeMs = timeMs;
        this.mTasksPerWorker = tasksPerWorker;
    }

    public long getTimeMs() {
        return this.mTimeMs;
    }

    public int getTasksPerWorker() {
        return this.mTasksPerWorker;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SleepJobConfig)) {
            return false;
        }
        SleepJobConfig that = (SleepJobConfig)obj;
        return this.mTimeMs == that.mTimeMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mTimeMs});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timeMs", this.mTimeMs).toString();
    }

    public String getName() {
        return NAME;
    }

    public Collection<String> affectedPaths() {
        return Collections.EMPTY_LIST;
    }
}

