/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.grpc.JobStatusBlock;
import alluxio.grpc.OperationType;
import alluxio.job.wire.SimpleJobStatusBlock;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CmdStatusBlock {
    private long mJobControlId;
    private List<SimpleJobStatusBlock> mJobStatusBlockList;
    private OperationType mOperationType;

    public CmdStatusBlock(long jobControlId, OperationType type) {
        this.mJobControlId = jobControlId;
        this.mJobStatusBlockList = Lists.newArrayList();
        this.mOperationType = type;
    }

    public CmdStatusBlock(long jobControlId, List<SimpleJobStatusBlock> blocks, OperationType type) {
        this.mJobControlId = jobControlId;
        this.mJobStatusBlockList = blocks;
        this.mOperationType = type;
    }

    public long getJobControlId() {
        return this.mJobControlId;
    }

    public void addJobStatusBlock(SimpleJobStatusBlock block) {
        this.mJobStatusBlockList.add(block);
    }

    public List<SimpleJobStatusBlock> getJobStatusBlock() {
        return this.mJobStatusBlockList;
    }

    public OperationType getOperationType() {
        return this.mOperationType;
    }

    public alluxio.grpc.CmdStatusBlock toProto() throws IOException {
        ArrayList jobStatusBlockList = Lists.newArrayList();
        this.mJobStatusBlockList.forEach(block -> {
            JobStatusBlock protoBlock = JobStatusBlock.newBuilder().setJobId(block.getJobId()).setJobStatus(block.getStatus().toProto()).setFilePath(block.getFilePath()).setFilePathFailed(block.getFilesPathFailed()).build();
            jobStatusBlockList.add(protoBlock);
        });
        return alluxio.grpc.CmdStatusBlock.newBuilder().setJobControlId(this.mJobControlId).addAllJobStatusBlock((Iterable)jobStatusBlockList).setOperationType(this.mOperationType).build();
    }
}

