/*
 * Decompiled with CFR 0.152.
 */
package alluxio.scheduler.job;

import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.JobProgressReportFormat;
import alluxio.job.JobDescription;
import alluxio.proto.journal.Journal;
import alluxio.scheduler.job.JobState;
import alluxio.scheduler.job.Task;
import alluxio.wire.WorkerInfo;
import java.util.Optional;
import java.util.OptionalLong;

public interface Job<T extends Task<?>> {
    public JobDescription getDescription();

    public OptionalLong getEndTime();

    public boolean needVerification();

    public JobState getJobState();

    public void setJobState(JobState var1);

    public String getJobId();

    public void failJob(AlluxioRuntimeException var1);

    public void setJobSuccess();

    public String getProgress(JobProgressReportFormat var1, boolean var2);

    public boolean isHealthy();

    public boolean isRunning();

    public boolean isDone();

    public boolean isCurrentPassDone();

    public void initiateVerification();

    public Optional<T> getNextTask(WorkerInfo var1);

    public Journal.JournalEntry toJournalEntry();

    public boolean processResponse(T var1);

    public void updateJob(Job<?> var1);
}

