/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.RuntimeConstants;
import alluxio.grpc.BuildVersion;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MasterWorkerInfo {
    private final WorkerNetAddress mWorkerAddress;
    private final long mId;
    private final BuildVersion mVersion;
    private final long mStartTimeMs;
    private long mLastUpdatedTimeMs;

    public MasterWorkerInfo(long id, WorkerNetAddress address) {
        this.mWorkerAddress = (WorkerNetAddress)Preconditions.checkNotNull((Object)address);
        this.mId = id;
        this.mStartTimeMs = System.currentTimeMillis();
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
        this.mVersion = RuntimeConstants.UNKNOWN_VERSION_INFO;
    }

    public MasterWorkerInfo(long id, WorkerNetAddress address, BuildVersion version) {
        this.mWorkerAddress = (WorkerNetAddress)Preconditions.checkNotNull((Object)address);
        this.mId = id;
        this.mStartTimeMs = System.currentTimeMillis();
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
        this.mVersion = version;
    }

    public synchronized WorkerNetAddress getWorkerAddress() {
        return this.mWorkerAddress;
    }

    public synchronized long getId() {
        return this.mId;
    }

    public synchronized long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public synchronized long getStartTime() {
        return this.mStartTimeMs;
    }

    public synchronized BuildVersion getVersion() {
        return this.mVersion;
    }

    public synchronized WorkerInfo generateClientWorkerInfo() {
        return new WorkerInfo().setId(this.mId).setAddress(this.mWorkerAddress).setLastContactSec((int)((CommonUtils.getCurrentMs() - this.mLastUpdatedTimeMs) / 1000L)).setState("In Service").setStartTimeMs(this.mStartTimeMs);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("MasterWorkerInfo(");
        sb.append(" ID: ").append(this.mId);
        sb.append(", mWorkerAddress: ").append(this.mWorkerAddress);
        sb.append(", mLastUpdatedTimeMs: ").append(this.mLastUpdatedTimeMs);
        return sb.toString();
    }

    public synchronized void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }
}

