/*
 * Decompiled with CFR 0.152.
 */
package alluxio.scheduler.job;

import alluxio.proto.journal.Job;

public enum JobState {
    RUNNING,
    VERIFYING,
    STOPPED,
    SUCCEEDED,
    FAILED;


    public static Job.PJobState toProto(JobState state) {
        switch (state) {
            case RUNNING: 
            case VERIFYING: {
                return Job.PJobState.CREATED;
            }
            case STOPPED: {
                return Job.PJobState.STOPPED;
            }
            case SUCCEEDED: {
                return Job.PJobState.SUCCEEDED;
            }
            case FAILED: {
                return Job.PJobState.FAILED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown state %s", new Object[]{state}));
    }

    public static JobState fromProto(Job.PJobState jobStatus) {
        switch (jobStatus) {
            case CREATED: {
                return RUNNING;
            }
            case STOPPED: {
                return STOPPED;
            }
            case SUCCEEDED: {
                return SUCCEEDED;
            }
            case FAILED: {
                return FAILED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown job status %s", jobStatus));
    }
}

