/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.cmd.persist;

import alluxio.job.cmd.persist.PersistCmdConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class PersistCmdConfigTest {
    @Test
    public void jsonTest() throws Exception {
        PersistCmdConfig config = new PersistCmdConfig("path", 0L, true, "ufs");
        ObjectMapper mapper = new ObjectMapper();
        PersistCmdConfig other = (PersistCmdConfig)mapper.readValue(mapper.writeValueAsString((Object)config), PersistCmdConfig.class);
        this.checkEquality(config, other);
    }

    @Test
    public void nullTest() {
        try {
            new PersistCmdConfig(null, 0L, true, "ufs");
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"The file path cannot be null", (Object)exception.getMessage());
        }
        try {
            new PersistCmdConfig("path", 0L, true, null);
            Assert.fail((String)"Cannot create config with null path");
        }
        catch (NullPointerException exception) {
            Assert.assertEquals((Object)"The UFS path cannot be null", (Object)exception.getMessage());
        }
    }

    public void checkEquality(PersistCmdConfig a, PersistCmdConfig b) {
        Assert.assertEquals((Object)a.getFilePath(), (Object)b.getFilePath());
        Assert.assertEquals((Object)a.getUfsPath(), (Object)b.getUfsPath());
        Assert.assertEquals((long)a.getMountId(), (long)b.getMountId());
        Assert.assertEquals((Object)a.isOverwrite(), (Object)b.isOverwrite());
        Assert.assertEquals((Object)a.getOperationType(), (Object)b.getOperationType());
        Assert.assertEquals((Object)a.getJobSource(), (Object)b.getJobSource());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

