/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.replicate;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@JsonTypeName(value="Replicate")
@ThreadSafe
public final class SetReplicaConfig
implements PlanConfig {
    private static final long serialVersionUID = 1807931900696165058L;
    public static final String NAME = "Replicate";
    private long mBlockId;
    private String mPath;
    private int mReplicas;

    @JsonCreator
    public SetReplicaConfig(@JsonProperty(value="path") String path, @JsonProperty(value="blockId") long blockId, @JsonProperty(value="replicas") int replicas) {
        Preconditions.checkArgument((replicas >= 0 ? 1 : 0) != 0, (Object)"replicas must be non-negative.");
        this.mBlockId = blockId;
        this.mPath = path;
        this.mReplicas = replicas;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<String> affectedPaths() {
        return ImmutableList.of((Object)this.mPath);
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public String getPath() {
        return this.mPath;
    }

    public int getReplicas() {
        return this.mReplicas;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SetReplicaConfig)) {
            return false;
        }
        SetReplicaConfig that = (SetReplicaConfig)obj;
        return Objects.equal((Object)this.mBlockId, (Object)that.mBlockId) && Objects.equal((Object)this.mPath, (Object)that.mPath) && Objects.equal((Object)this.mReplicas, (Object)that.mReplicas);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mBlockId, this.mPath, this.mReplicas});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockId", this.mBlockId).add("path", (Object)this.mPath).add("replicas", this.mReplicas).toString();
    }
}

